// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.LayerVersionContentInput
import aws.sdk.kotlin.services.lambda.model.PublishLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PublishLayerVersionOperationSerializer: HttpSerialize<PublishLayerVersionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PublishLayerVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "2018-10-31",
                "layers",
                "${input.layerName}".encodeLabel(),
                "versions",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePublishLayerVersionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePublishLayerVersionOperationBody(context: ExecutionContext, input: PublishLayerVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPATIBLEARCHITECTURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleArchitectures"))
    val COMPATIBLERUNTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleRuntimes"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Content"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LICENSEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPATIBLEARCHITECTURES_DESCRIPTOR)
        field(COMPATIBLERUNTIMES_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LICENSEINFO_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.compatibleArchitectures != null) {
            listField(COMPATIBLEARCHITECTURES_DESCRIPTOR) {
                for (el0 in input.compatibleArchitectures) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.compatibleRuntimes != null) {
            listField(COMPATIBLERUNTIMES_DESCRIPTOR) {
                for (el0 in input.compatibleRuntimes) {
                    serializeString(el0.value)
                }
            }
        }
        input.content?.let { field(CONTENT_DESCRIPTOR, it, ::serializeLayerVersionContentInputDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.licenseInfo?.let { field(LICENSEINFO_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
