// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.services.lambda.model.InvokeResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class InvokeOperationDeserializer: HttpDeserialize<InvokeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InvokeResponse {
        if (!response.status.isSuccess()) {
            throwInvokeError(context, response)
        }
        val builder = InvokeResponse.Builder()

        builder.executedVersion = response.headers["X-Amz-Executed-Version"]
        builder.functionError = response.headers["X-Amz-Function-Error"]
        builder.logResult = response.headers["X-Amz-Log-Result"]

        builder.payload = response.body.readAll()

        builder.statusCode = response.status.value
        return builder.build()
    }
}

private suspend fun throwInvokeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EC2AccessDeniedException" -> Ec2AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EC2ThrottledException" -> Ec2ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        "EC2UnexpectedException" -> Ec2UnexpectedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EFSIOException" -> EfsioExceptionDeserializer().deserialize(context, wrappedResponse)
        "EFSMountConnectivityException" -> EfsMountConnectivityExceptionDeserializer().deserialize(context, wrappedResponse)
        "EFSMountFailureException" -> EfsMountFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "EFSMountTimeoutException" -> EfsMountTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "ENILimitReachedException" -> EniLimitReachedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestContentException" -> InvalidRequestContentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRuntimeException" -> InvalidRuntimeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSecurityGroupIDException" -> InvalidSecurityGroupIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnetIDException" -> InvalidSubnetIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidZipFileException" -> InvalidZipFileExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSAccessDeniedException" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSDisabledException" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSNotFoundException" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestTooLargeException" -> RequestTooLargeExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotReadyException" -> ResourceNotReadyExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "SnapStartException" -> SnapStartExceptionDeserializer().deserialize(context, wrappedResponse)
        "SnapStartNotReadyException" -> SnapStartNotReadyExceptionDeserializer().deserialize(context, wrappedResponse)
        "SnapStartTimeoutException" -> SnapStartTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "SubnetIPAddressLimitReachedException" -> SubnetIpAddressLimitReachedExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedMediaTypeException" -> UnsupportedMediaTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
