// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.transform

import aws.sdk.kotlin.services.lambda.model.Architecture
import aws.sdk.kotlin.services.lambda.model.DeadLetterConfig
import aws.sdk.kotlin.services.lambda.model.EnvironmentResponse
import aws.sdk.kotlin.services.lambda.model.EphemeralStorage
import aws.sdk.kotlin.services.lambda.model.FileSystemConfig
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationResponse
import aws.sdk.kotlin.services.lambda.model.ImageConfigResponse
import aws.sdk.kotlin.services.lambda.model.LambdaException
import aws.sdk.kotlin.services.lambda.model.LastUpdateStatus
import aws.sdk.kotlin.services.lambda.model.LastUpdateStatusReasonCode
import aws.sdk.kotlin.services.lambda.model.Layer
import aws.sdk.kotlin.services.lambda.model.PackageType
import aws.sdk.kotlin.services.lambda.model.Runtime
import aws.sdk.kotlin.services.lambda.model.RuntimeVersionConfig
import aws.sdk.kotlin.services.lambda.model.SnapStartResponse
import aws.sdk.kotlin.services.lambda.model.State
import aws.sdk.kotlin.services.lambda.model.StateReasonCode
import aws.sdk.kotlin.services.lambda.model.TracingConfigResponse
import aws.sdk.kotlin.services.lambda.model.VpcConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetFunctionConfigurationOperationDeserializer: HttpDeserialize<GetFunctionConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFunctionConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetFunctionConfigurationError(context, response)
        }
        val builder = GetFunctionConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFunctionConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetFunctionConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LambdaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LambdaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFunctionConfigurationOperationBody(builder: GetFunctionConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARCHITECTURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Architectures"))
    val CODESHA256_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CodeSha256"))
    val CODESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("CodeSize"))
    val DEADLETTERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeadLetterConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Environment"))
    val EPHEMERALSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EphemeralStorage"))
    val FILESYSTEMCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FileSystemConfigs"))
    val FUNCTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionArn"))
    val FUNCTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionName"))
    val HANDLER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Handler"))
    val IMAGECONFIGRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageConfigResponse"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyArn"))
    val LASTMODIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastModified"))
    val LASTUPDATESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LastUpdateStatus"))
    val LASTUPDATESTATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastUpdateStatusReason"))
    val LASTUPDATESTATUSREASONCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LastUpdateStatusReasonCode"))
    val LAYERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Layers"))
    val MASTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MasterArn"))
    val MEMORYSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MemorySize"))
    val PACKAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PackageType"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RevisionId"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Role"))
    val RUNTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Runtime"))
    val RUNTIMEVERSIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuntimeVersionConfig"))
    val SIGNINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SigningJobArn"))
    val SIGNINGPROFILEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SigningProfileVersionArn"))
    val SNAPSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapStart"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val STATEREASONCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StateReasonCode"))
    val TIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Timeout"))
    val TRACINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TracingConfig"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Version"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHITECTURES_DESCRIPTOR)
        field(CODESHA256_DESCRIPTOR)
        field(CODESIZE_DESCRIPTOR)
        field(DEADLETTERCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EPHEMERALSTORAGE_DESCRIPTOR)
        field(FILESYSTEMCONFIGS_DESCRIPTOR)
        field(FUNCTIONARN_DESCRIPTOR)
        field(FUNCTIONNAME_DESCRIPTOR)
        field(HANDLER_DESCRIPTOR)
        field(IMAGECONFIGRESPONSE_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LASTMODIFIED_DESCRIPTOR)
        field(LASTUPDATESTATUS_DESCRIPTOR)
        field(LASTUPDATESTATUSREASON_DESCRIPTOR)
        field(LASTUPDATESTATUSREASONCODE_DESCRIPTOR)
        field(LAYERS_DESCRIPTOR)
        field(MASTERARN_DESCRIPTOR)
        field(MEMORYSIZE_DESCRIPTOR)
        field(PACKAGETYPE_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(RUNTIME_DESCRIPTOR)
        field(RUNTIMEVERSIONCONFIG_DESCRIPTOR)
        field(SIGNINGJOBARN_DESCRIPTOR)
        field(SIGNINGPROFILEVERSIONARN_DESCRIPTOR)
        field(SNAPSTART_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
        field(STATEREASONCODE_DESCRIPTOR)
        field(TIMEOUT_DESCRIPTOR)
        field(TRACINGCONFIG_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARCHITECTURES_DESCRIPTOR.index -> builder.architectures =
                    deserializer.deserializeList(ARCHITECTURES_DESCRIPTOR) {
                        val col0 = mutableListOf<Architecture>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Architecture.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CODESHA256_DESCRIPTOR.index -> builder.codeSha256 = deserializeString()
                CODESIZE_DESCRIPTOR.index -> builder.codeSize = deserializeLong()
                DEADLETTERCONFIG_DESCRIPTOR.index -> builder.deadLetterConfig = deserializeDeadLetterConfigDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENT_DESCRIPTOR.index -> builder.environment = deserializeEnvironmentResponseDocument(deserializer)
                EPHEMERALSTORAGE_DESCRIPTOR.index -> builder.ephemeralStorage = deserializeEphemeralStorageDocument(deserializer)
                FILESYSTEMCONFIGS_DESCRIPTOR.index -> builder.fileSystemConfigs =
                    deserializer.deserializeList(FILESYSTEMCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<FileSystemConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileSystemConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FUNCTIONARN_DESCRIPTOR.index -> builder.functionArn = deserializeString()
                FUNCTIONNAME_DESCRIPTOR.index -> builder.functionName = deserializeString()
                HANDLER_DESCRIPTOR.index -> builder.handler = deserializeString()
                IMAGECONFIGRESPONSE_DESCRIPTOR.index -> builder.imageConfigResponse = deserializeImageConfigResponseDocument(deserializer)
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LASTMODIFIED_DESCRIPTOR.index -> builder.lastModified = deserializeString()
                LASTUPDATESTATUS_DESCRIPTOR.index -> builder.lastUpdateStatus = deserializeString().let { LastUpdateStatus.fromValue(it) }
                LASTUPDATESTATUSREASON_DESCRIPTOR.index -> builder.lastUpdateStatusReason = deserializeString()
                LASTUPDATESTATUSREASONCODE_DESCRIPTOR.index -> builder.lastUpdateStatusReasonCode = deserializeString().let { LastUpdateStatusReasonCode.fromValue(it) }
                LAYERS_DESCRIPTOR.index -> builder.layers =
                    deserializer.deserializeList(LAYERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Layer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLayerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MASTERARN_DESCRIPTOR.index -> builder.masterArn = deserializeString()
                MEMORYSIZE_DESCRIPTOR.index -> builder.memorySize = deserializeInt()
                PACKAGETYPE_DESCRIPTOR.index -> builder.packageType = deserializeString().let { PackageType.fromValue(it) }
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                ROLE_DESCRIPTOR.index -> builder.role = deserializeString()
                RUNTIME_DESCRIPTOR.index -> builder.runtime = deserializeString().let { Runtime.fromValue(it) }
                RUNTIMEVERSIONCONFIG_DESCRIPTOR.index -> builder.runtimeVersionConfig = deserializeRuntimeVersionConfigDocument(deserializer)
                SIGNINGJOBARN_DESCRIPTOR.index -> builder.signingJobArn = deserializeString()
                SIGNINGPROFILEVERSIONARN_DESCRIPTOR.index -> builder.signingProfileVersionArn = deserializeString()
                SNAPSTART_DESCRIPTOR.index -> builder.snapStart = deserializeSnapStartResponseDocument(deserializer)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { State.fromValue(it) }
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                STATEREASONCODE_DESCRIPTOR.index -> builder.stateReasonCode = deserializeString().let { StateReasonCode.fromValue(it) }
                TIMEOUT_DESCRIPTOR.index -> builder.timeout = deserializeInt()
                TRACINGCONFIG_DESCRIPTOR.index -> builder.tracingConfig = deserializeTracingConfigResponseDocument(deserializer)
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
