// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.paginators

import aws.sdk.kotlin.services.lambda.LambdaClient
import aws.sdk.kotlin.services.lambda.model.AliasConfiguration
import aws.sdk.kotlin.services.lambda.model.CodeSigningConfig
import aws.sdk.kotlin.services.lambda.model.EventSourceMappingConfiguration
import aws.sdk.kotlin.services.lambda.model.FunctionConfiguration
import aws.sdk.kotlin.services.lambda.model.FunctionEventInvokeConfig
import aws.sdk.kotlin.services.lambda.model.FunctionUrlConfig
import aws.sdk.kotlin.services.lambda.model.LayerVersionsListItem
import aws.sdk.kotlin.services.lambda.model.LayersListItem
import aws.sdk.kotlin.services.lambda.model.ListAliasesRequest
import aws.sdk.kotlin.services.lambda.model.ListAliasesResponse
import aws.sdk.kotlin.services.lambda.model.ListCodeSigningConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListCodeSigningConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest
import aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionEventInvokeConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionEventInvokeConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
import aws.sdk.kotlin.services.lambda.model.ListFunctionsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsResponse
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsRequest
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsResponse
import aws.sdk.kotlin.services.lambda.model.ListLayersRequest
import aws.sdk.kotlin.services.lambda.model.ListLayersResponse
import aws.sdk.kotlin.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListProvisionedConcurrencyConfigsResponse
import aws.sdk.kotlin.services.lambda.model.ListVersionsByFunctionRequest
import aws.sdk.kotlin.services.lambda.model.ListVersionsByFunctionResponse
import aws.sdk.kotlin.services.lambda.model.ProvisionedConcurrencyConfigListItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun LambdaClient.listAliasesPaginated(initialRequest: ListAliasesRequest): Flow<ListAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAliasesPaginated.listAliases(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun LambdaClient.listAliasesPaginated(block: ListAliasesRequest.Builder.() -> Unit): Flow<ListAliasesResponse> =
    listAliasesPaginated(ListAliasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAliasesPaginated]
 * to access the nested member [AliasConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AliasConfiguration]
 */
@JvmName("listAliasesResponseAliasConfiguration")
public fun Flow<ListAliasesResponse>.aliases(): Flow<AliasConfiguration> =
    transform() { response ->
        response.aliases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCodeSigningConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCodeSigningConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCodeSigningConfigsResponse]
 */
public fun LambdaClient.listCodeSigningConfigsPaginated(initialRequest: ListCodeSigningConfigsRequest): Flow<ListCodeSigningConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listCodeSigningConfigsPaginated.listCodeSigningConfigs(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListCodeSigningConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCodeSigningConfigsResponse]
 */
public fun LambdaClient.listCodeSigningConfigsPaginated(block: ListCodeSigningConfigsRequest.Builder.() -> Unit): Flow<ListCodeSigningConfigsResponse> =
    listCodeSigningConfigsPaginated(ListCodeSigningConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCodeSigningConfigsPaginated]
 * to access the nested member [CodeSigningConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CodeSigningConfig]
 */
@JvmName("listCodeSigningConfigsResponseCodeSigningConfig")
public fun Flow<ListCodeSigningConfigsResponse>.codeSigningConfigs(): Flow<CodeSigningConfig> =
    transform() { response ->
        response.codeSigningConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventSourceMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventSourceMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventSourceMappingsResponse]
 */
public fun LambdaClient.listEventSourceMappingsPaginated(initialRequest: ListEventSourceMappingsRequest): Flow<ListEventSourceMappingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listEventSourceMappingsPaginated.listEventSourceMappings(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListEventSourceMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventSourceMappingsResponse]
 */
public fun LambdaClient.listEventSourceMappingsPaginated(block: ListEventSourceMappingsRequest.Builder.() -> Unit): Flow<ListEventSourceMappingsResponse> =
    listEventSourceMappingsPaginated(ListEventSourceMappingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventSourceMappingsPaginated]
 * to access the nested member [EventSourceMappingConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventSourceMappingConfiguration]
 */
@JvmName("listEventSourceMappingsResponseEventSourceMappingConfiguration")
public fun Flow<ListEventSourceMappingsResponse>.eventSourceMappings(): Flow<EventSourceMappingConfiguration> =
    transform() { response ->
        response.eventSourceMappings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFunctionEventInvokeConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFunctionEventInvokeConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionEventInvokeConfigsResponse]
 */
public fun LambdaClient.listFunctionEventInvokeConfigsPaginated(initialRequest: ListFunctionEventInvokeConfigsRequest): Flow<ListFunctionEventInvokeConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFunctionEventInvokeConfigsPaginated.listFunctionEventInvokeConfigs(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListFunctionEventInvokeConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionEventInvokeConfigsResponse]
 */
public fun LambdaClient.listFunctionEventInvokeConfigsPaginated(block: ListFunctionEventInvokeConfigsRequest.Builder.() -> Unit): Flow<ListFunctionEventInvokeConfigsResponse> =
    listFunctionEventInvokeConfigsPaginated(ListFunctionEventInvokeConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFunctionEventInvokeConfigsPaginated]
 * to access the nested member [FunctionEventInvokeConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionEventInvokeConfig]
 */
@JvmName("listFunctionEventInvokeConfigsResponseFunctionEventInvokeConfig")
public fun Flow<ListFunctionEventInvokeConfigsResponse>.functionEventInvokeConfigs(): Flow<FunctionEventInvokeConfig> =
    transform() { response ->
        response.functionEventInvokeConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFunctionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsResponse]
 */
public fun LambdaClient.listFunctionsPaginated(initialRequest: ListFunctionsRequest): Flow<ListFunctionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFunctionsPaginated.listFunctions(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListFunctionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsResponse]
 */
public fun LambdaClient.listFunctionsPaginated(block: ListFunctionsRequest.Builder.() -> Unit): Flow<ListFunctionsResponse> =
    listFunctionsPaginated(ListFunctionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFunctionsPaginated]
 * to access the nested member [FunctionConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionConfiguration]
 */
@JvmName("listFunctionsResponseFunctionConfiguration")
public fun Flow<ListFunctionsResponse>.functions(): Flow<FunctionConfiguration> =
    transform() { response ->
        response.functions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFunctionsByCodeSigningConfigResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFunctionsByCodeSigningConfigRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsByCodeSigningConfigResponse]
 */
public fun LambdaClient.listFunctionsByCodeSigningConfigPaginated(initialRequest: ListFunctionsByCodeSigningConfigRequest): Flow<ListFunctionsByCodeSigningConfigResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFunctionsByCodeSigningConfigPaginated.listFunctionsByCodeSigningConfig(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListFunctionsByCodeSigningConfigResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionsByCodeSigningConfigResponse]
 */
public fun LambdaClient.listFunctionsByCodeSigningConfigPaginated(block: ListFunctionsByCodeSigningConfigRequest.Builder.() -> Unit): Flow<ListFunctionsByCodeSigningConfigResponse> =
    listFunctionsByCodeSigningConfigPaginated(ListFunctionsByCodeSigningConfigRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFunctionsByCodeSigningConfigPaginated]
 * to access the nested member [FunctionArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionArn]
 */
@JvmName("listFunctionsByCodeSigningConfigResponseFunctionArn")
public fun Flow<ListFunctionsByCodeSigningConfigResponse>.functionArns(): Flow<String> =
    transform() { response ->
        response.functionArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFunctionUrlConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFunctionUrlConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionUrlConfigsResponse]
 */
public fun LambdaClient.listFunctionUrlConfigsPaginated(initialRequest: ListFunctionUrlConfigsRequest): Flow<ListFunctionUrlConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFunctionUrlConfigsPaginated.listFunctionUrlConfigs(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListFunctionUrlConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFunctionUrlConfigsResponse]
 */
public fun LambdaClient.listFunctionUrlConfigsPaginated(block: ListFunctionUrlConfigsRequest.Builder.() -> Unit): Flow<ListFunctionUrlConfigsResponse> =
    listFunctionUrlConfigsPaginated(ListFunctionUrlConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFunctionUrlConfigsPaginated]
 * to access the nested member [FunctionUrlConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionUrlConfig]
 */
@JvmName("listFunctionUrlConfigsResponseFunctionUrlConfig")
public fun Flow<ListFunctionUrlConfigsResponse>.functionUrlConfigs(): Flow<FunctionUrlConfig> =
    transform() { response ->
        response.functionUrlConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLayersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLayersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLayersResponse]
 */
public fun LambdaClient.listLayersPaginated(initialRequest: ListLayersRequest): Flow<ListLayersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listLayersPaginated.listLayers(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListLayersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLayersResponse]
 */
public fun LambdaClient.listLayersPaginated(block: ListLayersRequest.Builder.() -> Unit): Flow<ListLayersResponse> =
    listLayersPaginated(ListLayersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLayersPaginated]
 * to access the nested member [LayersListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LayersListItem]
 */
@JvmName("listLayersResponseLayersListItem")
public fun Flow<ListLayersResponse>.layers(): Flow<LayersListItem> =
    transform() { response ->
        response.layers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLayerVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLayerVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLayerVersionsResponse]
 */
public fun LambdaClient.listLayerVersionsPaginated(initialRequest: ListLayerVersionsRequest): Flow<ListLayerVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listLayerVersionsPaginated.listLayerVersions(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListLayerVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLayerVersionsResponse]
 */
public fun LambdaClient.listLayerVersionsPaginated(block: ListLayerVersionsRequest.Builder.() -> Unit): Flow<ListLayerVersionsResponse> =
    listLayerVersionsPaginated(ListLayerVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLayerVersionsPaginated]
 * to access the nested member [LayerVersionsListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LayerVersionsListItem]
 */
@JvmName("listLayerVersionsResponseLayerVersionsListItem")
public fun Flow<ListLayerVersionsResponse>.layerVersions(): Flow<LayerVersionsListItem> =
    transform() { response ->
        response.layerVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProvisionedConcurrencyConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProvisionedConcurrencyConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisionedConcurrencyConfigsResponse]
 */
public fun LambdaClient.listProvisionedConcurrencyConfigsPaginated(initialRequest: ListProvisionedConcurrencyConfigsRequest): Flow<ListProvisionedConcurrencyConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listProvisionedConcurrencyConfigsPaginated.listProvisionedConcurrencyConfigs(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListProvisionedConcurrencyConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisionedConcurrencyConfigsResponse]
 */
public fun LambdaClient.listProvisionedConcurrencyConfigsPaginated(block: ListProvisionedConcurrencyConfigsRequest.Builder.() -> Unit): Flow<ListProvisionedConcurrencyConfigsResponse> =
    listProvisionedConcurrencyConfigsPaginated(ListProvisionedConcurrencyConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProvisionedConcurrencyConfigsPaginated]
 * to access the nested member [ProvisionedConcurrencyConfigListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProvisionedConcurrencyConfigListItem]
 */
@JvmName("listProvisionedConcurrencyConfigsResponseProvisionedConcurrencyConfigListItem")
public fun Flow<ListProvisionedConcurrencyConfigsResponse>.provisionedConcurrencyConfigs(): Flow<ProvisionedConcurrencyConfigListItem> =
    transform() { response ->
        response.provisionedConcurrencyConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVersionsByFunctionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVersionsByFunctionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsByFunctionResponse]
 */
public fun LambdaClient.listVersionsByFunctionPaginated(initialRequest: ListVersionsByFunctionRequest): Flow<ListVersionsByFunctionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listVersionsByFunctionPaginated.listVersionsByFunction(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListVersionsByFunctionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsByFunctionResponse]
 */
public fun LambdaClient.listVersionsByFunctionPaginated(block: ListVersionsByFunctionRequest.Builder.() -> Unit): Flow<ListVersionsByFunctionResponse> =
    listVersionsByFunctionPaginated(ListVersionsByFunctionRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVersionsByFunctionPaginated]
 * to access the nested member [FunctionConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FunctionConfiguration]
 */
@JvmName("listVersionsByFunctionResponseFunctionConfiguration")
public fun Flow<ListVersionsByFunctionResponse>.versions(): Flow<FunctionConfiguration> =
    transform() { response ->
        response.versions?.forEach {
            emit(it)
        }
    }
