// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class ListAliasesRequest private constructor(builder: Builder) {
    /**
     * The name of the Lambda function.
     *
     * **Name formats**
     * + **Function name** - `MyFunction`.
     * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
     * + **Partial ARN** - `123456789012:function:MyFunction`.
     *
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * Specify a function version to only list aliases that invoke that version.
     */
    public val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Limit the number of aliases returned.
     */
    public val maxItems: kotlin.Int? = builder.maxItems

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.ListAliasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAliasesRequest(")
        append("functionName=$functionName,")
        append("functionVersion=$functionVersion,")
        append("marker=$marker,")
        append("maxItems=$maxItems")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionName?.hashCode() ?: 0
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAliasesRequest

        if (functionName != other.functionName) return false
        if (functionVersion != other.functionVersion) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.ListAliasesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Lambda function.
         *
         * **Name formats**
         * + **Function name** - `MyFunction`.
         * + **Function ARN** - `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
         * + **Partial ARN** - `123456789012:function:MyFunction`.
         *
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * Specify a function version to only list aliases that invoke that version.
         */
        public var functionVersion: kotlin.String? = null
        /**
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         */
        public var marker: kotlin.String? = null
        /**
         * Limit the number of aliases returned.
         */
        public var maxItems: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.ListAliasesRequest) : this() {
            this.functionName = x.functionName
            this.functionVersion = x.functionVersion
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.ListAliasesRequest = ListAliasesRequest(this)
    }
}
