// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model

import aws.smithy.kotlin.runtime.time.Instant

public class FunctionEventInvokeConfig private constructor(builder: Builder) {
    /**
     * A destination for events after they have been sent to a function for processing.
     *
     * **Destinations**
     * + **Function** - The Amazon Resource Name (ARN) of a Lambda function.
     * + **Queue** - The ARN of an SQS queue.
     * + **Topic** - The ARN of an SNS topic.
     * + **Event Bus** - The ARN of an Amazon EventBridge event bus.
     */
    public val destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = builder.destinationConfig
    /**
     * The Amazon Resource Name (ARN) of the function.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * The date and time that the configuration was last updated.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The maximum age of a request that Lambda sends to a function for processing.
     */
    public val maximumEventAgeInSeconds: kotlin.Int? = builder.maximumEventAgeInSeconds
    /**
     * The maximum number of times to retry when the function returns an error.
     */
    public val maximumRetryAttempts: kotlin.Int? = builder.maximumRetryAttempts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.FunctionEventInvokeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionEventInvokeConfig(")
        append("destinationConfig=$destinationConfig,")
        append("functionArn=$functionArn,")
        append("lastModified=$lastModified,")
        append("maximumEventAgeInSeconds=$maximumEventAgeInSeconds,")
        append("maximumRetryAttempts=$maximumRetryAttempts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfig?.hashCode() ?: 0
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (maximumEventAgeInSeconds ?: 0)
        result = 31 * result + (maximumRetryAttempts ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionEventInvokeConfig

        if (destinationConfig != other.destinationConfig) return false
        if (functionArn != other.functionArn) return false
        if (lastModified != other.lastModified) return false
        if (maximumEventAgeInSeconds != other.maximumEventAgeInSeconds) return false
        if (maximumRetryAttempts != other.maximumRetryAttempts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.FunctionEventInvokeConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A destination for events after they have been sent to a function for processing.
         *
         * **Destinations**
         * + **Function** - The Amazon Resource Name (ARN) of a Lambda function.
         * + **Queue** - The ARN of an SQS queue.
         * + **Topic** - The ARN of an SNS topic.
         * + **Event Bus** - The ARN of an Amazon EventBridge event bus.
         */
        public var destinationConfig: aws.sdk.kotlin.services.lambda.model.DestinationConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the function.
         */
        public var functionArn: kotlin.String? = null
        /**
         * The date and time that the configuration was last updated.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         */
        public var maximumEventAgeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of times to retry when the function returns an error.
         */
        public var maximumRetryAttempts: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.FunctionEventInvokeConfig) : this() {
            this.destinationConfig = x.destinationConfig
            this.functionArn = x.functionArn
            this.lastModified = x.lastModified
            this.maximumEventAgeInSeconds = x.maximumEventAgeInSeconds
            this.maximumRetryAttempts = x.maximumRetryAttempts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.FunctionEventInvokeConfig = FunctionEventInvokeConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.lambda.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.lambda.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.lambda.model.DestinationConfig.invoke(block)
        }
    }
}
