// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



/**
 * Specific configuration settings for a DocumentDB event source.
 */
public class DocumentDbEventSourceConfig private constructor(builder: Builder) {
    /**
     * The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
     */
    public val collectionName: kotlin.String? = builder.collectionName
    /**
     * The name of the database to consume within the DocumentDB cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes.
     */
    public val fullDocument: aws.sdk.kotlin.services.lambda.model.FullDocument? = builder.fullDocument

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.DocumentDbEventSourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentDbEventSourceConfig(")
        append("collectionName=$collectionName,")
        append("databaseName=$databaseName,")
        append("fullDocument=$fullDocument")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (fullDocument?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentDbEventSourceConfig

        if (collectionName != other.collectionName) return false
        if (databaseName != other.databaseName) return false
        if (fullDocument != other.fullDocument) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.DocumentDbEventSourceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
         */
        public var collectionName: kotlin.String? = null
        /**
         * The name of the database to consume within the DocumentDB cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes.
         */
        public var fullDocument: aws.sdk.kotlin.services.lambda.model.FullDocument? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.DocumentDbEventSourceConfig) : this() {
            this.collectionName = x.collectionName
            this.databaseName = x.databaseName
            this.fullDocument = x.fullDocument
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.DocumentDbEventSourceConfig = DocumentDbEventSourceConfig(this)
    }
}
