// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda.model



public class AddPermissionRequest private constructor(builder: Builder) {
    /**
     * The action that the principal can use on the function. For example, `lambda:InvokeFunction` or `lambda:GetFunction`.
     */
    public val action: kotlin.String? = builder.action
    /**
     * For Alexa Smart Home functions, a token that the invoker must supply.
     */
    public val eventSourceToken: kotlin.String? = builder.eventSourceToken
    /**
     * The name of the Lambda function, version, or alias.
     *
     * **Name formats**
     * + **Function name** – `my-function` (name-only), `my-function:v1` (with alias).
     * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
     * + **Partial ARN** – `123456789012:function:my-function`.
     *
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public val functionName: kotlin.String? = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
     */
    public val functionUrlAuthType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = builder.functionUrlAuthType
    /**
     * The Amazon Web Service or Amazon Web Services account that invokes the function. If you specify a service, use `SourceArn` or `SourceAccount` to limit who can invoke the function through that service.
     */
    public val principal: kotlin.String? = builder.principal
    /**
     * The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.
     */
    public val principalOrgId: kotlin.String? = builder.principalOrgId
    /**
     * Specify a version or alias to add permissions to a published version of the function.
     */
    public val qualifier: kotlin.String? = builder.qualifier
    /**
     * Update the policy only if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * For Amazon Web Service, the ID of the Amazon Web Services account that owns the resource. Use this together with `SourceArn` to ensure that the specified account owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
     */
    public val sourceAccount: kotlin.String? = builder.sourceAccount
    /**
     * For Amazon Web Services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.
     *
     * Note that Lambda configures the comparison using the `StringLike` operator.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * A statement identifier that differentiates the statement from others in the same policy.
     */
    public val statementId: kotlin.String? = builder.statementId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lambda.model.AddPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddPermissionRequest(")
        append("action=$action,")
        append("eventSourceToken=$eventSourceToken,")
        append("functionName=$functionName,")
        append("functionUrlAuthType=$functionUrlAuthType,")
        append("principal=$principal,")
        append("principalOrgId=$principalOrgId,")
        append("qualifier=$qualifier,")
        append("revisionId=$revisionId,")
        append("sourceAccount=$sourceAccount,")
        append("sourceArn=$sourceArn,")
        append("statementId=$statementId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (eventSourceToken?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (functionUrlAuthType?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (principalOrgId?.hashCode() ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (statementId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddPermissionRequest

        if (action != other.action) return false
        if (eventSourceToken != other.eventSourceToken) return false
        if (functionName != other.functionName) return false
        if (functionUrlAuthType != other.functionUrlAuthType) return false
        if (principal != other.principal) return false
        if (principalOrgId != other.principalOrgId) return false
        if (qualifier != other.qualifier) return false
        if (revisionId != other.revisionId) return false
        if (sourceAccount != other.sourceAccount) return false
        if (sourceArn != other.sourceArn) return false
        if (statementId != other.statementId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lambda.model.AddPermissionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that the principal can use on the function. For example, `lambda:InvokeFunction` or `lambda:GetFunction`.
         */
        public var action: kotlin.String? = null
        /**
         * For Alexa Smart Home functions, a token that the invoker must supply.
         */
        public var eventSourceToken: kotlin.String? = null
        /**
         * The name of the Lambda function, version, or alias.
         *
         * **Name formats**
         * + **Function name** – `my-function` (name-only), `my-function:v1` (with alias).
         * + **Function ARN** – `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
         * + **Partial ARN** – `123456789012:function:my-function`.
         *
         * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         */
        public var functionName: kotlin.String? = null
        /**
         * The type of authentication that your function URL uses. Set to `AWS_IAM` if you want to restrict access to authenticated users only. Set to `NONE` if you want to bypass IAM authentication to create a public endpoint. For more information, see [Security and auth model for Lambda function URLs](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html).
         */
        public var functionUrlAuthType: aws.sdk.kotlin.services.lambda.model.FunctionUrlAuthType? = null
        /**
         * The Amazon Web Service or Amazon Web Services account that invokes the function. If you specify a service, use `SourceArn` or `SourceAccount` to limit who can invoke the function through that service.
         */
        public var principal: kotlin.String? = null
        /**
         * The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.
         */
        public var principalOrgId: kotlin.String? = null
        /**
         * Specify a version or alias to add permissions to a published version of the function.
         */
        public var qualifier: kotlin.String? = null
        /**
         * Update the policy only if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.
         */
        public var revisionId: kotlin.String? = null
        /**
         * For Amazon Web Service, the ID of the Amazon Web Services account that owns the resource. Use this together with `SourceArn` to ensure that the specified account owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
         */
        public var sourceAccount: kotlin.String? = null
        /**
         * For Amazon Web Services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.
         *
         * Note that Lambda configures the comparison using the `StringLike` operator.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * A statement identifier that differentiates the statement from others in the same policy.
         */
        public var statementId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lambda.model.AddPermissionRequest) : this() {
            this.action = x.action
            this.eventSourceToken = x.eventSourceToken
            this.functionName = x.functionName
            this.functionUrlAuthType = x.functionUrlAuthType
            this.principal = x.principal
            this.principalOrgId = x.principalOrgId
            this.qualifier = x.qualifier
            this.revisionId = x.revisionId
            this.sourceAccount = x.sourceAccount
            this.sourceArn = x.sourceArn
            this.statementId = x.statementId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lambda.model.AddPermissionRequest = AddPermissionRequest(this)
    }
}
