// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lambda

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.lambda.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.lambda.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.lambda.model.*
import aws.sdk.kotlin.services.lambda.model.AddLayerVersionPermissionRequest
import aws.sdk.kotlin.services.lambda.model.AddPermissionRequest
import aws.sdk.kotlin.services.lambda.model.CreateAliasRequest
import aws.sdk.kotlin.services.lambda.model.CreateCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.CreateEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.CreateFunctionRequest
import aws.sdk.kotlin.services.lambda.model.CreateFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteAliasRequest
import aws.sdk.kotlin.services.lambda.model.DeleteCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.lambda.model.DeleteFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.DeleteLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.lambda.model.GetAliasRequest
import aws.sdk.kotlin.services.lambda.model.GetCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionRequest
import aws.sdk.kotlin.services.lambda.model.GetFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionByArnRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionPolicyRequest
import aws.sdk.kotlin.services.lambda.model.GetLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.GetPolicyRequest
import aws.sdk.kotlin.services.lambda.model.GetProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.GetRuntimeManagementConfigRequest
import aws.sdk.kotlin.services.lambda.model.InvokeAsyncRequest
import aws.sdk.kotlin.services.lambda.model.InvokeRequest
import aws.sdk.kotlin.services.lambda.model.ListAliasesRequest
import aws.sdk.kotlin.services.lambda.model.ListCodeSigningConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListEventSourceMappingsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionEventInvokeConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionUrlConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsByCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.ListFunctionsRequest
import aws.sdk.kotlin.services.lambda.model.ListLayerVersionsRequest
import aws.sdk.kotlin.services.lambda.model.ListLayersRequest
import aws.sdk.kotlin.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
import aws.sdk.kotlin.services.lambda.model.ListTagsRequest
import aws.sdk.kotlin.services.lambda.model.ListVersionsByFunctionRequest
import aws.sdk.kotlin.services.lambda.model.PublishLayerVersionRequest
import aws.sdk.kotlin.services.lambda.model.PublishVersionRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionConcurrencyRequest
import aws.sdk.kotlin.services.lambda.model.PutFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutProvisionedConcurrencyConfigRequest
import aws.sdk.kotlin.services.lambda.model.PutRuntimeManagementConfigRequest
import aws.sdk.kotlin.services.lambda.model.RemoveLayerVersionPermissionRequest
import aws.sdk.kotlin.services.lambda.model.RemovePermissionRequest
import aws.sdk.kotlin.services.lambda.model.TagResourceRequest
import aws.sdk.kotlin.services.lambda.model.UntagResourceRequest
import aws.sdk.kotlin.services.lambda.model.UpdateAliasRequest
import aws.sdk.kotlin.services.lambda.model.UpdateCodeSigningConfigRequest
import aws.sdk.kotlin.services.lambda.model.UpdateEventSourceMappingRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionCodeRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionConfigurationRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionEventInvokeConfigRequest
import aws.sdk.kotlin.services.lambda.model.UpdateFunctionUrlConfigRequest
import aws.sdk.kotlin.services.lambda.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Lambda"
public const val ServiceApiVersion: String = "2015-03-31"
public const val SdkVersion: String = "0.21.2-beta"

internal class DefaultLambdaClient(override val config: LambdaClient.Config) : LambdaClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds permissions to the resource-based policy of a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.
     *
     * To revoke permission, call RemoveLayerVersionPermission with the statement ID that you specified when you added it.
     */
    override suspend fun addLayerVersionPermission(input: AddLayerVersionPermissionRequest): AddLayerVersionPermissionResponse {
        val op = SdkHttpOperation.build<AddLayerVersionPermissionRequest, AddLayerVersionPermissionResponse> {
            serializer = AddLayerVersionPermissionOperationSerializer()
            deserializer = AddLayerVersionPermissionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "AddLayerVersionPermission"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AddLayerVersionPermissionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddLayerVersionPermission-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services organization permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.
     *
     * To grant permission to another account, specify the account ID as the `Principal`. To grant permission to an organization defined in Organizations, specify the organization ID as the `PrincipalOrgID`. For Amazon Web Services, the principal is a domain-style identifier that the service defines, such as `s3.amazonaws.com` or `sns.amazonaws.com`. For Amazon Web Services, you can also specify the ARN of the associated resource as the `SourceArn`. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.
     *
     * This operation adds a statement to a resource-based permissions policy for the function. For more information about function policies, see [Using resource-based policies for Lambda](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html).
     */
    override suspend fun addPermission(input: AddPermissionRequest): AddPermissionResponse {
        val op = SdkHttpOperation.build<AddPermissionRequest, AddPermissionResponse> {
            serializer = AddPermissionOperationSerializer()
            deserializer = AddPermissionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "AddPermission"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AddPermissionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddPermission-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html) for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.
     *
     * You can also map an alias to split invocation requests between two versions. Use the `RoutingConfig` parameter to specify a second version and the percentage of invocation requests that it receives.
     */
    override suspend fun createAlias(input: CreateAliasRequest): CreateAliasResponse {
        val op = SdkHttpOperation.build<CreateAliasRequest, CreateAliasResponse> {
            serializer = CreateAliasOperationSerializer()
            deserializer = CreateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateAlias"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateAliasRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a code signing configuration. A [code signing configuration](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html) defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
     */
    override suspend fun createCodeSigningConfig(input: CreateCodeSigningConfigRequest): CreateCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<CreateCodeSigningConfigRequest, CreateCodeSigningConfigResponse> {
            serializer = CreateCodeSigningConfigOperationSerializer()
            deserializer = CreateCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and invokes the function.
     *
     * For details about how to configure different event sources, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
     *
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * + `BisectBatchOnFunctionError` – If the function returns an error, split the batch in two and retry.
     * + `DestinationConfig` – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * + `MaximumRecordAgeInSeconds` – Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * + `MaximumRetryAttempts` – Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * + `ParallelizationFactor` – Process multiple batches from each shard concurrently.
     *
     * For information about which configuration parameters apply to each event source, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
     */
    override suspend fun createEventSourceMapping(input: CreateEventSourceMappingRequest): CreateEventSourceMappingResponse {
        val op = SdkHttpOperation.build<CreateEventSourceMappingRequest, CreateEventSourceMappingResponse> {
            serializer = CreateEventSourceMappingOperationSerializer()
            deserializer = CreateEventSourceMappingOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "CreateEventSourceMapping"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateEventSourceMappingRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEventSourceMapping-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.
     *
     * If the deployment package is a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html), then you set the package type to `Image`. For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     *
     * If the deployment package is a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip), then you set the package type to `Zip`. For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`). If you do not specify the architecture, then the default value is `x86-64`.
     *
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify the function. The `State`, `StateReason`, and `StateReasonCode` fields in the response from GetFunctionConfiguration indicate when the function is ready to invoke. For more information, see [Lambda function states](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
     *
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function's code and configuration. A published version is a snapshot of your function code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the `Publish` parameter to create version `1` of your function from its initial configuration.
     *
     * The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with UpdateFunctionConfiguration. Function-level settings apply to both the unpublished and published versions of the function, and include tags (TagResource) and per-function concurrency limits (PutFunctionConcurrency).
     *
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with UpdateFunctionCode, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set of signing profiles, which define the trusted publishers for this function.
     *
     * If another Amazon Web Services account or an Amazon Web Service invokes your function, use AddPermission to grant permission by creating a resource-based Identity and Access Management (IAM) policy. You can grant permissions at the function level, on a version, or on an alias.
     *
     * To invoke your function directly, use Invoke. To invoke your function in response to events in other Amazon Web Services, create an event source mapping (CreateEventSourceMapping), or configure a function trigger in the other service. For more information, see [Invoking Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html).
     */
    override suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse {
        val op = SdkHttpOperation.build<CreateFunctionRequest, CreateFunctionResponse> {
            serializer = CreateFunctionOperationSerializer()
            deserializer = CreateFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S) endpoint that you can use to invoke your function.
     */
    override suspend fun createFunctionUrlConfig(input: CreateFunctionUrlConfigRequest): CreateFunctionUrlConfigResponse {
        val op = SdkHttpOperation.build<CreateFunctionUrlConfigRequest, CreateFunctionUrlConfigResponse> {
            serializer = CreateFunctionUrlConfigOperationSerializer()
            deserializer = CreateFunctionUrlConfigOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "CreateFunctionUrlConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFunctionUrlConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFunctionUrlConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
     */
    override suspend fun deleteAlias(input: DeleteAliasRequest): DeleteAliasResponse {
        val op = SdkHttpOperation.build<DeleteAliasRequest, DeleteAliasResponse> {
            serializer = DeleteAliasOperationSerializer()
            deserializer = DeleteAliasOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteAlias"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAliasRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it.
     */
    override suspend fun deleteCodeSigningConfig(input: DeleteCodeSigningConfigRequest): DeleteCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<DeleteCodeSigningConfigRequest, DeleteCodeSigningConfigResponse> {
            serializer = DeleteCodeSigningConfigOperationSerializer()
            deserializer = DeleteCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an [event source mapping](https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html). You can get the identifier of a mapping from the output of ListEventSourceMappings.
     *
     * When you delete an event source mapping, it enters a `Deleting` state and might not be completely deleted for several seconds.
     */
    override suspend fun deleteEventSourceMapping(input: DeleteEventSourceMappingRequest): DeleteEventSourceMappingResponse {
        val op = SdkHttpOperation.build<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResponse> {
            serializer = DeleteEventSourceMappingOperationSerializer()
            deserializer = DeleteEventSourceMappingOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "DeleteEventSourceMapping"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEventSourceMappingRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEventSourceMapping-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Lambda function. To delete a specific function version, use the `Qualifier` parameter. Otherwise, all versions and aliases are deleted.
     *
     * To delete Lambda event source mappings that invoke a function, use DeleteEventSourceMapping. For Amazon Web Services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.
     */
    override suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse {
        val op = SdkHttpOperation.build<DeleteFunctionRequest, DeleteFunctionResponse> {
            serializer = DeleteFunctionOperationSerializer()
            deserializer = DeleteFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the code signing configuration from the function.
     */
    override suspend fun deleteFunctionCodeSigningConfig(input: DeleteFunctionCodeSigningConfigRequest): DeleteFunctionCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<DeleteFunctionCodeSigningConfigRequest, DeleteFunctionCodeSigningConfigResponse> {
            serializer = DeleteFunctionCodeSigningConfigOperationSerializer()
            deserializer = DeleteFunctionCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFunctionCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunctionCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes a concurrent execution limit from a function.
     */
    override suspend fun deleteFunctionConcurrency(input: DeleteFunctionConcurrencyRequest): DeleteFunctionConcurrencyResponse {
        val op = SdkHttpOperation.build<DeleteFunctionConcurrencyRequest, DeleteFunctionConcurrencyResponse> {
            serializer = DeleteFunctionConcurrencyOperationSerializer()
            deserializer = DeleteFunctionConcurrencyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFunctionConcurrency"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionConcurrencyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunctionConcurrency-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    override suspend fun deleteFunctionEventInvokeConfig(input: DeleteFunctionEventInvokeConfigRequest): DeleteFunctionEventInvokeConfigResponse {
        val op = SdkHttpOperation.build<DeleteFunctionEventInvokeConfigRequest, DeleteFunctionEventInvokeConfigResponse> {
            serializer = DeleteFunctionEventInvokeConfigOperationSerializer()
            deserializer = DeleteFunctionEventInvokeConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFunctionEventInvokeConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionEventInvokeConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunctionEventInvokeConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL results in a different URL address.
     */
    override suspend fun deleteFunctionUrlConfig(input: DeleteFunctionUrlConfigRequest): DeleteFunctionUrlConfigResponse {
        val op = SdkHttpOperation.build<DeleteFunctionUrlConfigRequest, DeleteFunctionUrlConfigResponse> {
            serializer = DeleteFunctionUrlConfigOperationSerializer()
            deserializer = DeleteFunctionUrlConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteFunctionUrlConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFunctionUrlConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFunctionUrlConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.
     */
    override suspend fun deleteLayerVersion(input: DeleteLayerVersionRequest): DeleteLayerVersionResponse {
        val op = SdkHttpOperation.build<DeleteLayerVersionRequest, DeleteLayerVersionResponse> {
            serializer = DeleteLayerVersionOperationSerializer()
            deserializer = DeleteLayerVersionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteLayerVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteLayerVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteLayerVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the provisioned concurrency configuration for a function.
     */
    override suspend fun deleteProvisionedConcurrencyConfig(input: DeleteProvisionedConcurrencyConfigRequest): DeleteProvisionedConcurrencyConfigResponse {
        val op = SdkHttpOperation.build<DeleteProvisionedConcurrencyConfigRequest, DeleteProvisionedConcurrencyConfigResponse> {
            serializer = DeleteProvisionedConcurrencyConfigOperationSerializer()
            deserializer = DeleteProvisionedConcurrencyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "DeleteProvisionedConcurrencyConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteProvisionedConcurrencyConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteProvisionedConcurrencyConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves details about your account's [limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html) and usage in an Amazon Web Services Region.
     */
    override suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse {
        val op = SdkHttpOperation.build<GetAccountSettingsRequest, GetAccountSettingsResponse> {
            serializer = GetAccountSettingsOperationSerializer()
            deserializer = GetAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetAccountSettings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetAccountSettingsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetAccountSettings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details about a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
     */
    override suspend fun getAlias(input: GetAliasRequest): GetAliasResponse {
        val op = SdkHttpOperation.build<GetAliasRequest, GetAliasResponse> {
            serializer = GetAliasOperationSerializer()
            deserializer = GetAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetAlias"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetAliasRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the specified code signing configuration.
     */
    override suspend fun getCodeSigningConfig(input: GetCodeSigningConfigRequest): GetCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<GetCodeSigningConfigRequest, GetCodeSigningConfigResponse> {
            serializer = GetCodeSigningConfigOperationSerializer()
            deserializer = GetCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of ListEventSourceMappings.
     */
    override suspend fun getEventSourceMapping(input: GetEventSourceMappingRequest): GetEventSourceMappingResponse {
        val op = SdkHttpOperation.build<GetEventSourceMappingRequest, GetEventSourceMappingResponse> {
            serializer = GetEventSourceMappingOperationSerializer()
            deserializer = GetEventSourceMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEventSourceMapping"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetEventSourceMappingRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEventSourceMapping-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.
     */
    override suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse {
        val op = SdkHttpOperation.build<GetFunctionRequest, GetFunctionResponse> {
            serializer = GetFunctionOperationSerializer()
            deserializer = GetFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the code signing configuration for the specified function.
     */
    override suspend fun getFunctionCodeSigningConfig(input: GetFunctionCodeSigningConfigRequest): GetFunctionCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<GetFunctionCodeSigningConfigRequest, GetFunctionCodeSigningConfigResponse> {
            serializer = GetFunctionCodeSigningConfigOperationSerializer()
            deserializer = GetFunctionCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunctionCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunctionCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use PutFunctionConcurrency.
     */
    override suspend fun getFunctionConcurrency(input: GetFunctionConcurrencyRequest): GetFunctionConcurrencyResponse {
        val op = SdkHttpOperation.build<GetFunctionConcurrencyRequest, GetFunctionConcurrencyResponse> {
            serializer = GetFunctionConcurrencyOperationSerializer()
            deserializer = GetFunctionConcurrencyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunctionConcurrency"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionConcurrencyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunctionConcurrency-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use UpdateFunctionConfiguration.
     *
     * To get all of a function's details, including function-level settings, use GetFunction.
     */
    override suspend fun getFunctionConfiguration(input: GetFunctionConfigurationRequest): GetFunctionConfigurationResponse {
        val op = SdkHttpOperation.build<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse> {
            serializer = GetFunctionConfigurationOperationSerializer()
            deserializer = GetFunctionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunctionConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunctionConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    override suspend fun getFunctionEventInvokeConfig(input: GetFunctionEventInvokeConfigRequest): GetFunctionEventInvokeConfigResponse {
        val op = SdkHttpOperation.build<GetFunctionEventInvokeConfigRequest, GetFunctionEventInvokeConfigResponse> {
            serializer = GetFunctionEventInvokeConfigOperationSerializer()
            deserializer = GetFunctionEventInvokeConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunctionEventInvokeConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionEventInvokeConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunctionEventInvokeConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details about a Lambda function URL.
     */
    override suspend fun getFunctionUrlConfig(input: GetFunctionUrlConfigRequest): GetFunctionUrlConfigResponse {
        val op = SdkHttpOperation.build<GetFunctionUrlConfigRequest, GetFunctionUrlConfigResponse> {
            serializer = GetFunctionUrlConfigOperationSerializer()
            deserializer = GetFunctionUrlConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetFunctionUrlConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetFunctionUrlConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetFunctionUrlConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
     */
    override suspend fun getLayerVersion(input: GetLayerVersionRequest): GetLayerVersionResponse {
        val op = SdkHttpOperation.build<GetLayerVersionRequest, GetLayerVersionResponse> {
            serializer = GetLayerVersionOperationSerializer()
            deserializer = GetLayerVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetLayerVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetLayerVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLayerVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html), with a link to download the layer archive that's valid for 10 minutes.
     */
    override suspend fun getLayerVersionByArn(input: GetLayerVersionByArnRequest): GetLayerVersionByArnResponse {
        val op = SdkHttpOperation.build<GetLayerVersionByArnRequest, GetLayerVersionByArnResponse> {
            serializer = GetLayerVersionByArnOperationSerializer()
            deserializer = GetLayerVersionByArnOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetLayerVersionByArn"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetLayerVersionByArnRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLayerVersionByArn-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the permission policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
     */
    override suspend fun getLayerVersionPolicy(input: GetLayerVersionPolicyRequest): GetLayerVersionPolicyResponse {
        val op = SdkHttpOperation.build<GetLayerVersionPolicyRequest, GetLayerVersionPolicyResponse> {
            serializer = GetLayerVersionPolicyOperationSerializer()
            deserializer = GetLayerVersionPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetLayerVersionPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetLayerVersionPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLayerVersionPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the [resource-based IAM policy](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html) for a function, version, or alias.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetPolicy"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetPolicyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetPolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     */
    override suspend fun getProvisionedConcurrencyConfig(input: GetProvisionedConcurrencyConfigRequest): GetProvisionedConcurrencyConfigResponse {
        val op = SdkHttpOperation.build<GetProvisionedConcurrencyConfigRequest, GetProvisionedConcurrencyConfigResponse> {
            serializer = GetProvisionedConcurrencyConfigOperationSerializer()
            deserializer = GetProvisionedConcurrencyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetProvisionedConcurrencyConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetProvisionedConcurrencyConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetProvisionedConcurrencyConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the runtime management configuration for a function's version. If the runtime update mode is **Manual**, this includes the ARN of the runtime version and the runtime update mode. If the runtime update mode is **Auto** or **Function update**, this includes the runtime update mode and `null` is returned for the ARN. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
     */
    override suspend fun getRuntimeManagementConfig(input: GetRuntimeManagementConfigRequest): GetRuntimeManagementConfigResponse {
        val op = SdkHttpOperation.build<GetRuntimeManagementConfigRequest, GetRuntimeManagementConfigResponse> {
            serializer = GetRuntimeManagementConfigOperationSerializer()
            deserializer = GetRuntimeManagementConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetRuntimeManagementConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetRuntimeManagementConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRuntimeManagementConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. To invoke a function asynchronously, set `InvocationType` to `Event`.
     *
     * For [synchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html), details about the function response, including errors, are included in the response body and headers. For either invocation type, you can find more information in the [execution log](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html) and [trace](https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html).
     *
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error, Lambda executes the function up to two more times. For more information, see [Error handling and automatic retries in Lambda](https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html).
     *
     * For [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html), Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple times, even if no error occurs. To retain events that were not processed, configure your function with a [dead-letter queue](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
     *
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your function from executing, such as permissions errors, [quota](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html) errors, or issues with your function's code and configuration. For example, Lambda returns `TooManyRequestsException` if running the function would cause you to exceed a concurrency limit at either the account level (`ConcurrentInvocationLimitExceeded`) or function level (`ReservedFunctionConcurrentInvocationLimitExceeded`).
     *
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections with timeout or keep-alive settings.
     *
     * This operation requires permission for the [lambda:InvokeFunction](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html) action. For details on how to set up permissions for cross-account invocations, see [Granting function access to other accounts](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke).
     */
    override suspend fun invoke(input: InvokeRequest): InvokeResponse {
        val op = SdkHttpOperation.build<InvokeRequest, InvokeResponse> {
            serializer = InvokeOperationSerializer()
            deserializer = InvokeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "Invoke"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<InvokeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("Invoke-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * For asynchronous function invocation, use Invoke.
     *
     * Invokes a function asynchronously.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun invokeAsync(input: InvokeAsyncRequest): InvokeAsyncResponse {
        val op = SdkHttpOperation.build<InvokeAsyncRequest, InvokeAsyncResponse> {
            serializer = InvokeAsyncOperationSerializer()
            deserializer = InvokeAsyncOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "InvokeAsync"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<InvokeAsyncRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("InvokeAsync-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of [aliases](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html) for a Lambda function.
     */
    override suspend fun listAliases(input: ListAliasesRequest): ListAliasesResponse {
        val op = SdkHttpOperation.build<ListAliasesRequest, ListAliasesResponse> {
            serializer = ListAliasesOperationSerializer()
            deserializer = ListAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListAliases"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListAliasesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAliases-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of [code signing configurations](https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html). A request returns up to 10,000 configurations per call. You can use the `MaxItems` parameter to return fewer configurations per call.
     */
    override suspend fun listCodeSigningConfigs(input: ListCodeSigningConfigsRequest): ListCodeSigningConfigsResponse {
        val op = SdkHttpOperation.build<ListCodeSigningConfigsRequest, ListCodeSigningConfigsResponse> {
            serializer = ListCodeSigningConfigsOperationSerializer()
            deserializer = ListCodeSigningConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListCodeSigningConfigs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCodeSigningConfigsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCodeSigningConfigs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists event source mappings. Specify an `EventSourceArn` to show only event source mappings for a single event source.
     */
    override suspend fun listEventSourceMappings(input: ListEventSourceMappingsRequest): ListEventSourceMappingsResponse {
        val op = SdkHttpOperation.build<ListEventSourceMappingsRequest, ListEventSourceMappingsResponse> {
            serializer = ListEventSourceMappingsOperationSerializer()
            deserializer = ListEventSourceMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEventSourceMappings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListEventSourceMappingsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEventSourceMappings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of configurations for asynchronous invocation for a function.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    override suspend fun listFunctionEventInvokeConfigs(input: ListFunctionEventInvokeConfigsRequest): ListFunctionEventInvokeConfigsResponse {
        val op = SdkHttpOperation.build<ListFunctionEventInvokeConfigsRequest, ListFunctionEventInvokeConfigsResponse> {
            serializer = ListFunctionEventInvokeConfigsOperationSerializer()
            deserializer = ListFunctionEventInvokeConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFunctionEventInvokeConfigs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFunctionEventInvokeConfigsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFunctionEventInvokeConfigs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of Lambda function URLs for the specified function.
     */
    override suspend fun listFunctionUrlConfigs(input: ListFunctionUrlConfigsRequest): ListFunctionUrlConfigsResponse {
        val op = SdkHttpOperation.build<ListFunctionUrlConfigsRequest, ListFunctionUrlConfigsResponse> {
            serializer = ListFunctionUrlConfigsOperationSerializer()
            deserializer = ListFunctionUrlConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFunctionUrlConfigs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFunctionUrlConfigsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFunctionUrlConfigs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.
     *
     * Set `FunctionVersion` to `ALL` to include all published versions of each function in addition to the unpublished version.
     *
     * The `ListFunctions` operation returns a subset of the FunctionConfiguration fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use GetFunction.
     */
    override suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse {
        val op = SdkHttpOperation.build<ListFunctionsRequest, ListFunctionsResponse> {
            serializer = ListFunctionsOperationSerializer()
            deserializer = ListFunctionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFunctions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFunctionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFunctions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.
     */
    override suspend fun listFunctionsByCodeSigningConfig(input: ListFunctionsByCodeSigningConfigRequest): ListFunctionsByCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<ListFunctionsByCodeSigningConfigRequest, ListFunctionsByCodeSigningConfigResponse> {
            serializer = ListFunctionsByCodeSigningConfigOperationSerializer()
            deserializer = ListFunctionsByCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFunctionsByCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFunctionsByCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFunctionsByCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the versions of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). Versions that have been deleted aren't listed. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.
     */
    override suspend fun listLayerVersions(input: ListLayerVersionsRequest): ListLayerVersionsResponse {
        val op = SdkHttpOperation.build<ListLayerVersionsRequest, ListLayerVersionsResponse> {
            serializer = ListLayerVersionsOperationSerializer()
            deserializer = ListLayerVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLayerVersions"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListLayerVersionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListLayerVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists [Lambda layers](https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html) and shows information about the latest version of each. Specify a [runtime identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list only layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that [instruction set architecture](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html).
     */
    override suspend fun listLayers(input: ListLayersRequest): ListLayersResponse {
        val op = SdkHttpOperation.build<ListLayersRequest, ListLayersResponse> {
            serializer = ListLayersOperationSerializer()
            deserializer = ListLayersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLayers"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListLayersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListLayers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a list of provisioned concurrency configurations for a function.
     */
    override suspend fun listProvisionedConcurrencyConfigs(input: ListProvisionedConcurrencyConfigsRequest): ListProvisionedConcurrencyConfigsResponse {
        val op = SdkHttpOperation.build<ListProvisionedConcurrencyConfigsRequest, ListProvisionedConcurrencyConfigsResponse> {
            serializer = ListProvisionedConcurrencyConfigsOperationSerializer()
            deserializer = ListProvisionedConcurrencyConfigsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListProvisionedConcurrencyConfigs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListProvisionedConcurrencyConfigsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListProvisionedConcurrencyConfigs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a function's [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html). You can also view tags with GetFunction.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTags"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of [versions](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html), with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     */
    override suspend fun listVersionsByFunction(input: ListVersionsByFunctionRequest): ListVersionsByFunctionResponse {
        val op = SdkHttpOperation.build<ListVersionsByFunctionRequest, ListVersionsByFunctionResponse> {
            serializer = ListVersionsByFunctionOperationSerializer()
            deserializer = ListVersionsByFunctionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListVersionsByFunction"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListVersionsByFunctionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListVersionsByFunction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) from a ZIP archive. Each time you call `PublishLayerVersion` with the same layer name, a new version is created.
     *
     * Add layers to your function with CreateFunction or UpdateFunctionConfiguration.
     */
    override suspend fun publishLayerVersion(input: PublishLayerVersionRequest): PublishLayerVersionResponse {
        val op = SdkHttpOperation.build<PublishLayerVersionRequest, PublishLayerVersionResponse> {
            serializer = PublishLayerVersionOperationSerializer()
            deserializer = PublishLayerVersionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "PublishLayerVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PublishLayerVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PublishLayerVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a [version](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html) from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.
     *
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version. Use UpdateFunctionCode or UpdateFunctionConfiguration to update the function before publishing a version.
     *
     * Clients can invoke versions directly or with an alias. To create an alias, use CreateAlias.
     */
    override suspend fun publishVersion(input: PublishVersionRequest): PublishVersionResponse {
        val op = SdkHttpOperation.build<PublishVersionRequest, PublishVersionResponse> {
            serializer = PublishVersionOperationSerializer()
            deserializer = PublishVersionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                operationName = "PublishVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PublishVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PublishVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
     */
    override suspend fun putFunctionCodeSigningConfig(input: PutFunctionCodeSigningConfigRequest): PutFunctionCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<PutFunctionCodeSigningConfigRequest, PutFunctionCodeSigningConfigResponse> {
            serializer = PutFunctionCodeSigningConfigOperationSerializer()
            deserializer = PutFunctionCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutFunctionCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutFunctionCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutFunctionCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.
     *
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use GetFunction to see the current setting for a function.
     *
     * Use GetAccountSettings to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren't configured with a per-function limit. For more information, see [Lambda function scaling](https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html).
     */
    override suspend fun putFunctionConcurrency(input: PutFunctionConcurrencyRequest): PutFunctionConcurrencyResponse {
        val op = SdkHttpOperation.build<PutFunctionConcurrencyRequest, PutFunctionConcurrencyResponse> {
            serializer = PutFunctionConcurrencyOperationSerializer()
            deserializer = PutFunctionConcurrencyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutFunctionConcurrency"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutFunctionConcurrencyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutFunctionConcurrency-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Configures options for [asynchronous invocation](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html) on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use UpdateFunctionEventInvokeConfig.
     *
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with UpdateFunctionConfiguration.
     *
     * To send an invocation record to a queue, topic, function, or event bus, specify a [destination](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations). You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.
     */
    override suspend fun putFunctionEventInvokeConfig(input: PutFunctionEventInvokeConfigRequest): PutFunctionEventInvokeConfigResponse {
        val op = SdkHttpOperation.build<PutFunctionEventInvokeConfigRequest, PutFunctionEventInvokeConfigResponse> {
            serializer = PutFunctionEventInvokeConfigOperationSerializer()
            deserializer = PutFunctionEventInvokeConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutFunctionEventInvokeConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutFunctionEventInvokeConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutFunctionEventInvokeConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds a provisioned concurrency configuration to a function's alias or version.
     */
    override suspend fun putProvisionedConcurrencyConfig(input: PutProvisionedConcurrencyConfigRequest): PutProvisionedConcurrencyConfigResponse {
        val op = SdkHttpOperation.build<PutProvisionedConcurrencyConfigRequest, PutProvisionedConcurrencyConfigResponse> {
            serializer = PutProvisionedConcurrencyConfigOperationSerializer()
            deserializer = PutProvisionedConcurrencyConfigOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "PutProvisionedConcurrencyConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutProvisionedConcurrencyConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutProvisionedConcurrencyConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
     */
    override suspend fun putRuntimeManagementConfig(input: PutRuntimeManagementConfigRequest): PutRuntimeManagementConfigResponse {
        val op = SdkHttpOperation.build<PutRuntimeManagementConfigRequest, PutRuntimeManagementConfigResponse> {
            serializer = PutRuntimeManagementConfigOperationSerializer()
            deserializer = PutRuntimeManagementConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutRuntimeManagementConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PutRuntimeManagementConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutRuntimeManagementConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes a statement from the permissions policy for a version of an [Lambda layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). For more information, see AddLayerVersionPermission.
     */
    override suspend fun removeLayerVersionPermission(input: RemoveLayerVersionPermissionRequest): RemoveLayerVersionPermissionResponse {
        val op = SdkHttpOperation.build<RemoveLayerVersionPermissionRequest, RemoveLayerVersionPermissionResponse> {
            serializer = RemoveLayerVersionPermissionOperationSerializer()
            deserializer = RemoveLayerVersionPermissionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "RemoveLayerVersionPermission"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveLayerVersionPermissionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveLayerVersionPermission-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Revokes function-use permission from an Amazon Web Service or another Amazon Web Services account. You can get the ID of the statement from the output of GetPolicy.
     */
    override suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse {
        val op = SdkHttpOperation.build<RemovePermissionRequest, RemovePermissionResponse> {
            serializer = RemovePermissionOperationSerializer()
            deserializer = RemovePermissionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "RemovePermission"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemovePermissionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemovePermission-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to a function.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) from a function.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration of a Lambda function [alias](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html).
     */
    override suspend fun updateAlias(input: UpdateAliasRequest): UpdateAliasResponse {
        val op = SdkHttpOperation.build<UpdateAliasRequest, UpdateAliasResponse> {
            serializer = UpdateAliasOperationSerializer()
            deserializer = UpdateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateAlias"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateAliasRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function.
     */
    override suspend fun updateCodeSigningConfig(input: UpdateCodeSigningConfigRequest): UpdateCodeSigningConfigResponse {
        val op = SdkHttpOperation.build<UpdateCodeSigningConfigRequest, UpdateCodeSigningConfigResponse> {
            serializer = UpdateCodeSigningConfigOperationSerializer()
            deserializer = UpdateCodeSigningConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateCodeSigningConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCodeSigningConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCodeSigningConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.
     *
     * For details about how to configure different event sources, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html)
     *
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * + `BisectBatchOnFunctionError` – If the function returns an error, split the batch in two and retry.
     * + `DestinationConfig` – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * + `MaximumRecordAgeInSeconds` – Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * + `MaximumRetryAttempts` – Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * + `ParallelizationFactor` – Process multiple batches from each shard concurrently.
     *
     * For information about which configuration parameters apply to each event source, see the following topics.
     * + [ Amazon DynamoDB Streams](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params)
     * + [ Amazon Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params)
     * + [ Amazon SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params)
     * + [ Amazon MQ and RabbitMQ](https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params)
     * + [ Amazon MSK](https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms)
     * + [ Apache Kafka](https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms)
     */
    override suspend fun updateEventSourceMapping(input: UpdateEventSourceMappingRequest): UpdateEventSourceMappingResponse {
        val op = SdkHttpOperation.build<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResponse> {
            serializer = UpdateEventSourceMappingOperationSerializer()
            deserializer = UpdateEventSourceMappingOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "UpdateEventSourceMapping"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEventSourceMappingRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEventSourceMapping-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see [Configuring code signing for Lambda](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).
     *
     * If the function's package type is `Image`, then you must specify the code package in `ImageUri` as the URI of a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html) in the Amazon ECR registry.
     *
     * If the function's package type is `Zip`, then you must specify the deployment package as a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the function code inline using the `ZipFile` field.
     *
     * The code in the deployment package must be compatible with the target instruction set architecture of the function (`x86-64` or `arm64`).
     *
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only the unpublished version.
     *
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.
     */
    override suspend fun updateFunctionCode(input: UpdateFunctionCodeRequest): UpdateFunctionCodeResponse {
        val op = SdkHttpOperation.build<UpdateFunctionCodeRequest, UpdateFunctionCodeResponse> {
            serializer = UpdateFunctionCodeOperationSerializer()
            deserializer = UpdateFunctionCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFunctionCode"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFunctionCodeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFunctionCode-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modify the version-specific settings of a Lambda function.
     *
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but you can still invoke it. The `LastUpdateStatus`, `LastUpdateStatusReason`, and `LastUpdateStatusReasonCode` fields in the response from GetFunctionConfiguration indicate when the update is complete and the function is processing events with the new configuration. For more information, see [Lambda function states](https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
     *
     * These settings can vary between versions of a function and are locked when you publish a version. You can't modify the configuration of a published version, only the unpublished version.
     *
     * To configure function concurrency, use PutFunctionConcurrency. To grant invoke permissions to an Amazon Web Services account or Amazon Web Service, use AddPermission.
     */
    override suspend fun updateFunctionConfiguration(input: UpdateFunctionConfigurationRequest): UpdateFunctionConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResponse> {
            serializer = UpdateFunctionConfigurationOperationSerializer()
            deserializer = UpdateFunctionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFunctionConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFunctionConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFunctionConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     *
     * To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
     */
    override suspend fun updateFunctionEventInvokeConfig(input: UpdateFunctionEventInvokeConfigRequest): UpdateFunctionEventInvokeConfigResponse {
        val op = SdkHttpOperation.build<UpdateFunctionEventInvokeConfigRequest, UpdateFunctionEventInvokeConfigResponse> {
            serializer = UpdateFunctionEventInvokeConfigOperationSerializer()
            deserializer = UpdateFunctionEventInvokeConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFunctionEventInvokeConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFunctionEventInvokeConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFunctionEventInvokeConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration for a Lambda function URL.
     */
    override suspend fun updateFunctionUrlConfig(input: UpdateFunctionUrlConfigRequest): UpdateFunctionUrlConfigResponse {
        val op = SdkHttpOperation.build<UpdateFunctionUrlConfigRequest, UpdateFunctionUrlConfigResponse> {
            serializer = UpdateFunctionUrlConfigOperationSerializer()
            deserializer = UpdateFunctionUrlConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFunctionUrlConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateFunctionUrlConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "lambda"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFunctionUrlConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lambda")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
