// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.LakeFormationException
import aws.sdk.kotlin.services.lakeformation.model.SearchDatabasesByLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.TaggedDatabase
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SearchDatabasesByLFTagsOperationDeserializer: HttpDeserializer.NonStreaming<SearchDatabasesByLfTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SearchDatabasesByLfTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSearchDatabasesByLfTagsError(context, call, payload)
        }
        val builder = SearchDatabasesByLfTagsResponse.Builder()

        if (payload != null) {
            deserializeSearchDatabasesByLFTagsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSearchDatabasesByLfTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LakeFormationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "GlueEncryptionException" -> GlueEncryptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationTimeoutException" -> OperationTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LakeFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchDatabasesByLFTagsOperationBody(builder: SearchDatabasesByLfTagsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATABASELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DatabaseList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATABASELIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATABASELIST_DESCRIPTOR.index -> builder.databaseList =
                    deserializer.deserializeList(DATABASELIST_DESCRIPTOR) {
                        val col0 = mutableListOf<TaggedDatabase>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTaggedDatabaseDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
