// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse
import aws.sdk.kotlin.services.lakeformation.model.LakeFormationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class AssumeDecoratedRoleWithSAMLOperationDeserializer: HttpDeserializer.NonStreaming<AssumeDecoratedRoleWithSamlResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssumeDecoratedRoleWithSamlResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeDecoratedRoleWithSamlError(context, call, payload)
        }
        val builder = AssumeDecoratedRoleWithSamlResponse.Builder()

        if (payload != null) {
            deserializeAssumeDecoratedRoleWithSAMLOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssumeDecoratedRoleWithSamlError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LakeFormationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationTimeoutException" -> OperationTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LakeFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeDecoratedRoleWithSAMLOperationBody(builder: AssumeDecoratedRoleWithSamlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessKeyId"))
    val EXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Expiration"))
    val SECRETACCESSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretAccessKey"))
    val SESSIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSKEYID_DESCRIPTOR)
        field(EXPIRATION_DESCRIPTOR)
        field(SECRETACCESSKEY_DESCRIPTOR)
        field(SESSIONTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSKEYID_DESCRIPTOR.index -> builder.accessKeyId = deserializeString()
                EXPIRATION_DESCRIPTOR.index -> builder.expiration = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SECRETACCESSKEY_DESCRIPTOR.index -> builder.secretAccessKey = deserializeString()
                SESSIONTOKEN_DESCRIPTOR.index -> builder.sessionToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
