// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.paginators

import aws.sdk.kotlin.services.lakeformation.LakeFormationClient
import aws.sdk.kotlin.services.lakeformation.model.DataCellsFilter
import aws.sdk.kotlin.services.lakeformation.model.GetEffectivePermissionsForPathRequest
import aws.sdk.kotlin.services.lakeformation.model.GetEffectivePermissionsForPathResponse
import aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitsResponse
import aws.sdk.kotlin.services.lakeformation.model.LfTagExpression
import aws.sdk.kotlin.services.lakeformation.model.LfTagPair
import aws.sdk.kotlin.services.lakeformation.model.ListDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.ListDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLakeFormationOptInsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLakeFormationOptInsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagExpressionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagExpressionsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListPermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListPermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListResourcesRequest
import aws.sdk.kotlin.services.lakeformation.model.ListResourcesResponse
import aws.sdk.kotlin.services.lakeformation.model.ListTableStorageOptimizersRequest
import aws.sdk.kotlin.services.lakeformation.model.ListTableStorageOptimizersResponse
import aws.sdk.kotlin.services.lakeformation.model.ListTransactionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListTransactionsResponse
import aws.sdk.kotlin.services.lakeformation.model.SearchDatabasesByLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.SearchDatabasesByLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.SearchTablesByLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.SearchTablesByLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.TaggedDatabase
import aws.sdk.kotlin.services.lakeformation.model.TaggedTable
import aws.sdk.kotlin.services.lakeformation.model.WorkUnitRange
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetEffectivePermissionsForPathResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEffectivePermissionsForPathRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEffectivePermissionsForPathResponse]
 */
public fun LakeFormationClient.getEffectivePermissionsForPathPaginated(initialRequest: GetEffectivePermissionsForPathRequest): Flow<GetEffectivePermissionsForPathResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEffectivePermissionsForPathPaginated.getEffectivePermissionsForPath(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetEffectivePermissionsForPathResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEffectivePermissionsForPathResponse]
 */
public fun LakeFormationClient.getEffectivePermissionsForPathPaginated(block: GetEffectivePermissionsForPathRequest.Builder.() -> Unit): Flow<GetEffectivePermissionsForPathResponse> =
    getEffectivePermissionsForPathPaginated(GetEffectivePermissionsForPathRequest.Builder().apply(block).build())

/**
 * Paginate over [GetTableObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTableObjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTableObjectsResponse]
 */
public fun LakeFormationClient.getTableObjectsPaginated(initialRequest: GetTableObjectsRequest): Flow<GetTableObjectsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTableObjectsPaginated.getTableObjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetTableObjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTableObjectsResponse]
 */
public fun LakeFormationClient.getTableObjectsPaginated(block: GetTableObjectsRequest.Builder.() -> Unit): Flow<GetTableObjectsResponse> =
    getTableObjectsPaginated(GetTableObjectsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetWorkUnitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetWorkUnitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetWorkUnitsResponse]
 */
public fun LakeFormationClient.getWorkUnitsPaginated(initialRequest: GetWorkUnitsRequest): Flow<GetWorkUnitsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getWorkUnitsPaginated.getWorkUnits(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetWorkUnitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetWorkUnitsResponse]
 */
public fun LakeFormationClient.getWorkUnitsPaginated(block: GetWorkUnitsRequest.Builder.() -> Unit): Flow<GetWorkUnitsResponse> =
    getWorkUnitsPaginated(GetWorkUnitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getWorkUnitsPaginated]
 * to access the nested member [WorkUnitRange]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkUnitRange]
 */
@JvmName("getWorkUnitsResponseWorkUnitRange")
public fun Flow<GetWorkUnitsResponse>.workUnitRanges(): Flow<WorkUnitRange> =
    transform() { response ->
        response.workUnitRanges?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataCellsFilterResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataCellsFilterRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataCellsFilterResponse]
 */
public fun LakeFormationClient.listDataCellsFilterPaginated(initialRequest: ListDataCellsFilterRequest = ListDataCellsFilterRequest { }): Flow<ListDataCellsFilterResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataCellsFilterPaginated.listDataCellsFilter(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataCellsFilterResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataCellsFilterResponse]
 */
public fun LakeFormationClient.listDataCellsFilterPaginated(block: ListDataCellsFilterRequest.Builder.() -> Unit): Flow<ListDataCellsFilterResponse> =
    listDataCellsFilterPaginated(ListDataCellsFilterRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataCellsFilterPaginated]
 * to access the nested member [DataCellsFilter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataCellsFilter]
 */
@JvmName("listDataCellsFilterResponseDataCellsFilter")
public fun Flow<ListDataCellsFilterResponse>.dataCellsFilters(): Flow<DataCellsFilter> =
    transform() { response ->
        response.dataCellsFilters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLakeFormationOptInsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLakeFormationOptInsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLakeFormationOptInsResponse]
 */
public fun LakeFormationClient.listLakeFormationOptInsPaginated(initialRequest: ListLakeFormationOptInsRequest = ListLakeFormationOptInsRequest { }): Flow<ListLakeFormationOptInsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLakeFormationOptInsPaginated.listLakeFormationOptIns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLakeFormationOptInsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLakeFormationOptInsResponse]
 */
public fun LakeFormationClient.listLakeFormationOptInsPaginated(block: ListLakeFormationOptInsRequest.Builder.() -> Unit): Flow<ListLakeFormationOptInsResponse> =
    listLakeFormationOptInsPaginated(ListLakeFormationOptInsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLfTagExpressionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLfTagExpressionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLfTagExpressionsResponse]
 */
public fun LakeFormationClient.listLfTagExpressionsPaginated(initialRequest: ListLfTagExpressionsRequest = ListLfTagExpressionsRequest { }): Flow<ListLfTagExpressionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLfTagExpressionsPaginated.listLfTagExpressions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLfTagExpressionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLfTagExpressionsResponse]
 */
public fun LakeFormationClient.listLfTagExpressionsPaginated(block: ListLfTagExpressionsRequest.Builder.() -> Unit): Flow<ListLfTagExpressionsResponse> =
    listLfTagExpressionsPaginated(ListLfTagExpressionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLfTagExpressionsPaginated]
 * to access the nested member [LfTagExpression]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LfTagExpression]
 */
@JvmName("listLfTagExpressionsResponseLfTagExpression")
public fun Flow<ListLfTagExpressionsResponse>.lfTagExpressions(): Flow<LfTagExpression> =
    transform() { response ->
        response.lfTagExpressions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLfTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLfTagsResponse]
 */
public fun LakeFormationClient.listLfTagsPaginated(initialRequest: ListLfTagsRequest = ListLfTagsRequest { }): Flow<ListLfTagsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLfTagsPaginated.listLfTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLfTagsResponse]
 */
public fun LakeFormationClient.listLfTagsPaginated(block: ListLfTagsRequest.Builder.() -> Unit): Flow<ListLfTagsResponse> =
    listLfTagsPaginated(ListLfTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLfTagsPaginated]
 * to access the nested member [LfTagPair]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LfTagPair]
 */
@JvmName("listLfTagsResponseLfTagPair")
public fun Flow<ListLfTagsResponse>.lfTags(): Flow<LfTagPair> =
    transform() { response ->
        response.lfTags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun LakeFormationClient.listPermissionsPaginated(initialRequest: ListPermissionsRequest = ListPermissionsRequest { }): Flow<ListPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionsPaginated.listPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun LakeFormationClient.listPermissionsPaginated(block: ListPermissionsRequest.Builder.() -> Unit): Flow<ListPermissionsResponse> =
    listPermissionsPaginated(ListPermissionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
public fun LakeFormationClient.listResourcesPaginated(initialRequest: ListResourcesRequest = ListResourcesRequest { }): Flow<ListResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourcesPaginated.listResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesResponse]
 */
public fun LakeFormationClient.listResourcesPaginated(block: ListResourcesRequest.Builder.() -> Unit): Flow<ListResourcesResponse> =
    listResourcesPaginated(ListResourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTableStorageOptimizersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableStorageOptimizersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableStorageOptimizersResponse]
 */
public fun LakeFormationClient.listTableStorageOptimizersPaginated(initialRequest: ListTableStorageOptimizersRequest): Flow<ListTableStorageOptimizersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableStorageOptimizersPaginated.listTableStorageOptimizers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTableStorageOptimizersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableStorageOptimizersResponse]
 */
public fun LakeFormationClient.listTableStorageOptimizersPaginated(block: ListTableStorageOptimizersRequest.Builder.() -> Unit): Flow<ListTableStorageOptimizersResponse> =
    listTableStorageOptimizersPaginated(ListTableStorageOptimizersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTransactionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionsResponse]
 */
public fun LakeFormationClient.listTransactionsPaginated(initialRequest: ListTransactionsRequest = ListTransactionsRequest { }): Flow<ListTransactionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTransactionsPaginated.listTransactions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionsResponse]
 */
public fun LakeFormationClient.listTransactionsPaginated(block: ListTransactionsRequest.Builder.() -> Unit): Flow<ListTransactionsResponse> =
    listTransactionsPaginated(ListTransactionsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchDatabasesByLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchDatabasesByLfTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDatabasesByLfTagsResponse]
 */
public fun LakeFormationClient.searchDatabasesByLfTagsPaginated(initialRequest: SearchDatabasesByLfTagsRequest): Flow<SearchDatabasesByLfTagsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchDatabasesByLfTagsPaginated.searchDatabasesByLfTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchDatabasesByLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDatabasesByLfTagsResponse]
 */
public fun LakeFormationClient.searchDatabasesByLfTagsPaginated(block: SearchDatabasesByLfTagsRequest.Builder.() -> Unit): Flow<SearchDatabasesByLfTagsResponse> =
    searchDatabasesByLfTagsPaginated(SearchDatabasesByLfTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchDatabasesByLfTagsPaginated]
 * to access the nested member [TaggedDatabase]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaggedDatabase]
 */
@JvmName("searchDatabasesByLfTagsResponseTaggedDatabase")
public fun Flow<SearchDatabasesByLfTagsResponse>.databaseList(): Flow<TaggedDatabase> =
    transform() { response ->
        response.databaseList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchTablesByLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchTablesByLfTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchTablesByLfTagsResponse]
 */
public fun LakeFormationClient.searchTablesByLfTagsPaginated(initialRequest: SearchTablesByLfTagsRequest): Flow<SearchTablesByLfTagsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchTablesByLfTagsPaginated.searchTablesByLfTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchTablesByLfTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchTablesByLfTagsResponse]
 */
public fun LakeFormationClient.searchTablesByLfTagsPaginated(block: SearchTablesByLfTagsRequest.Builder.() -> Unit): Flow<SearchTablesByLfTagsResponse> =
    searchTablesByLfTagsPaginated(SearchTablesByLfTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchTablesByLfTagsPaginated]
 * to access the nested member [TaggedTable]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaggedTable]
 */
@JvmName("searchTablesByLfTagsResponseTaggedTable")
public fun Flow<SearchTablesByLfTagsResponse>.tableList(): Flow<TaggedTable> =
    transform() { response ->
        response.tableList?.forEach {
            emit(it)
        }
    }
