// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A permission to a resource granted by batch operation to the principal.
 */
public class BatchPermissionsRequestEntry private constructor(builder: Builder) {
    /**
     * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     */
    public val condition: aws.sdk.kotlin.services.lakeformation.model.Condition? = builder.condition
    /**
     * A unique identifier for the batch permissions request entry.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The permissions to be granted.
     */
    public val permissions: List<Permission>? = builder.permissions
    /**
     * Indicates if the option to pass permissions is granted.
     */
    public val permissionsWithGrantOption: List<Permission>? = builder.permissionsWithGrantOption
    /**
     * The principal to be granted a permission.
     */
    public val principal: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal? = builder.principal
    /**
     * The resource to which the principal is to be granted a permission.
     */
    public val resource: aws.sdk.kotlin.services.lakeformation.model.Resource? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.BatchPermissionsRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPermissionsRequestEntry(")
        append("condition=$condition,")
        append("id=$id,")
        append("permissions=$permissions,")
        append("permissionsWithGrantOption=$permissionsWithGrantOption,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (permissionsWithGrantOption?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPermissionsRequestEntry

        if (condition != other.condition) return false
        if (id != other.id) return false
        if (permissions != other.permissions) return false
        if (permissionsWithGrantOption != other.permissionsWithGrantOption) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.BatchPermissionsRequestEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         */
        public var condition: aws.sdk.kotlin.services.lakeformation.model.Condition? = null
        /**
         * A unique identifier for the batch permissions request entry.
         */
        public var id: kotlin.String? = null
        /**
         * The permissions to be granted.
         */
        public var permissions: List<Permission>? = null
        /**
         * Indicates if the option to pass permissions is granted.
         */
        public var permissionsWithGrantOption: List<Permission>? = null
        /**
         * The principal to be granted a permission.
         */
        public var principal: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal? = null
        /**
         * The resource to which the principal is to be granted a permission.
         */
        public var resource: aws.sdk.kotlin.services.lakeformation.model.Resource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.BatchPermissionsRequestEntry) : this() {
            this.condition = x.condition
            this.id = x.id
            this.permissions = x.permissions
            this.permissionsWithGrantOption = x.permissionsWithGrantOption
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.BatchPermissionsRequestEntry = BatchPermissionsRequestEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.Condition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.lakeformation.model.Condition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.lakeformation.model.Condition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal] inside the given [block]
         */
        public fun principal(block: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal.Builder.() -> kotlin.Unit) {
            this.principal = aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.Resource] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.lakeformation.model.Resource.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.lakeformation.model.Resource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            return this
        }
    }
}
