// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal
import aws.sdk.kotlin.services.lakeformation.model.DataLakeResourceType
import aws.sdk.kotlin.services.lakeformation.model.ListPermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.Resource
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListPermissionsOperationSerializer: HttpSerializer.NonStreaming<ListPermissionsRequest> {
    override fun serialize(context: ExecutionContext, input: ListPermissionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/ListPermissions"
        }

        val payload = serializeListPermissionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListPermissionsOperationBody(context: ExecutionContext, input: ListPermissionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CATALOGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CatalogId"))
    val INCLUDERELATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IncludeRelated"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PRINCIPAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Principal"))
    val RESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Resource"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ResourceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CATALOGID_DESCRIPTOR)
        field(INCLUDERELATED_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PRINCIPAL_DESCRIPTOR)
        field(RESOURCE_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.catalogId?.let { field(CATALOGID_DESCRIPTOR, it) }
        input.includeRelated?.let { field(INCLUDERELATED_DESCRIPTOR, it) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.principal?.let { field(PRINCIPAL_DESCRIPTOR, it, ::serializeDataLakePrincipalDocument) }
        input.resource?.let { field(RESOURCE_DESCRIPTOR, it, ::serializeResourceDocument) }
        input.resourceType?.let { field(RESOURCETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
