// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal
import aws.sdk.kotlin.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse
import aws.sdk.kotlin.services.lakeformation.model.ExternalFilteringConfiguration
import aws.sdk.kotlin.services.lakeformation.model.LakeFormationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeLakeFormationIdentityCenterConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLakeFormationIdentityCenterConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLakeFormationIdentityCenterConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLakeFormationIdentityCenterConfigurationError(context, call, payload)
        }
        val builder = DescribeLakeFormationIdentityCenterConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeLakeFormationIdentityCenterConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLakeFormationIdentityCenterConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LakeFormationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationTimeoutException" -> OperationTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LakeFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLakeFormationIdentityCenterConfigurationOperationBody(builder: DescribeLakeFormationIdentityCenterConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationArn"))
    val CATALOGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CatalogId"))
    val EXTERNALFILTERING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExternalFiltering"))
    val INSTANCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceArn"))
    val RESOURCESHARE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceShare"))
    val SHARERECIPIENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ShareRecipients"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONARN_DESCRIPTOR)
        field(CATALOGID_DESCRIPTOR)
        field(EXTERNALFILTERING_DESCRIPTOR)
        field(INSTANCEARN_DESCRIPTOR)
        field(RESOURCESHARE_DESCRIPTOR)
        field(SHARERECIPIENTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONARN_DESCRIPTOR.index -> builder.applicationArn = deserializeString()
                CATALOGID_DESCRIPTOR.index -> builder.catalogId = deserializeString()
                EXTERNALFILTERING_DESCRIPTOR.index -> builder.externalFiltering = deserializeExternalFilteringConfigurationDocument(deserializer)
                INSTANCEARN_DESCRIPTOR.index -> builder.instanceArn = deserializeString()
                RESOURCESHARE_DESCRIPTOR.index -> builder.resourceShare = deserializeString()
                SHARERECIPIENTS_DESCRIPTOR.index -> builder.shareRecipients =
                    deserializer.deserializeList(SHARERECIPIENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataLakePrincipal>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataLakePrincipalDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
