// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure for the table object. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
 */
public class TableResource private constructor(builder: Builder) {
    /**
     * The identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The name of the table.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A wildcard object representing every table under a database.
     *
     * At least one of `TableResource$Name` or `TableResource$TableWildcard` is required.
     */
    public val tableWildcard: aws.sdk.kotlin.services.lakeformation.model.TableWildcard? = builder.tableWildcard

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.TableResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableResource(")
        append("catalogId=$catalogId,")
        append("databaseName=$databaseName,")
        append("name=$name,")
        append("tableWildcard=$tableWildcard")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tableWildcard?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableResource

        if (catalogId != other.catalogId) return false
        if (databaseName != other.databaseName) return false
        if (name != other.name) return false
        if (tableWildcard != other.tableWildcard) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.TableResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the Data Catalog. By default, it is the account ID of the caller.
         */
        public var catalogId: kotlin.String? = null
        /**
         * The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The name of the table.
         */
        public var name: kotlin.String? = null
        /**
         * A wildcard object representing every table under a database.
         *
         * At least one of `TableResource$Name` or `TableResource$TableWildcard` is required.
         */
        public var tableWildcard: aws.sdk.kotlin.services.lakeformation.model.TableWildcard? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.TableResource) : this() {
            this.catalogId = x.catalogId
            this.databaseName = x.databaseName
            this.name = x.name
            this.tableWildcard = x.tableWildcard
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.TableResource = TableResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.TableWildcard] inside the given [block]
         */
        public fun tableWildcard(block: aws.sdk.kotlin.services.lakeformation.model.TableWildcard.Builder.() -> kotlin.Unit) {
            this.tableWildcard = aws.sdk.kotlin.services.lakeformation.model.TableWildcard.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            return this
        }
    }
}
