// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure describing the configuration and details of a storage optimizer.
 */
public class StorageOptimizer private constructor(builder: Builder) {
    /**
     * A map of the storage optimizer configuration. Currently contains only one key-value pair: `is_enabled` indicates true or false for acceleration.
     */
    public val config: Map<String, String>? = builder.config
    /**
     * A message that contains information about any error (if present).
     *
     * When an acceleration result has an enabled status, the error message is empty.
     *
     * When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * When an acceleration result has an enabled status, contains the details of the last job run.
     */
    public val lastRunDetails: kotlin.String? = builder.lastRunDetails
    /**
     * The specific type of storage optimizer. The supported value is `compaction`.
     */
    public val storageOptimizerType: aws.sdk.kotlin.services.lakeformation.model.OptimizerType? = builder.storageOptimizerType
    /**
     * A message that contains information about any warnings (if present).
     */
    public val warnings: kotlin.String? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.StorageOptimizer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageOptimizer(")
        append("config=$config,")
        append("errorMessage=$errorMessage,")
        append("lastRunDetails=$lastRunDetails,")
        append("storageOptimizerType=$storageOptimizerType,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = config?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (lastRunDetails?.hashCode() ?: 0)
        result = 31 * result + (storageOptimizerType?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageOptimizer

        if (config != other.config) return false
        if (errorMessage != other.errorMessage) return false
        if (lastRunDetails != other.lastRunDetails) return false
        if (storageOptimizerType != other.storageOptimizerType) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.StorageOptimizer = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of the storage optimizer configuration. Currently contains only one key-value pair: `is_enabled` indicates true or false for acceleration.
         */
        public var config: Map<String, String>? = null
        /**
         * A message that contains information about any error (if present).
         *
         * When an acceleration result has an enabled status, the error message is empty.
         *
         * When an acceleration result has a disabled status, the message describes an error or simply indicates "disabled by the user".
         */
        public var errorMessage: kotlin.String? = null
        /**
         * When an acceleration result has an enabled status, contains the details of the last job run.
         */
        public var lastRunDetails: kotlin.String? = null
        /**
         * The specific type of storage optimizer. The supported value is `compaction`.
         */
        public var storageOptimizerType: aws.sdk.kotlin.services.lakeformation.model.OptimizerType? = null
        /**
         * A message that contains information about any warnings (if present).
         */
        public var warnings: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.StorageOptimizer) : this() {
            this.config = x.config
            this.errorMessage = x.errorMessage
            this.lastRunDetails = x.lastRunDetails
            this.storageOptimizerType = x.storageOptimizerType
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.StorageOptimizer = StorageOptimizer(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
