// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure containing information about an Lake Formation resource.
 */
public class ResourceInfo private constructor(builder: Builder) {
    /**
     * Indicates whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
     */
    public val hybridAccessEnabled: kotlin.Boolean? = builder.hybridAccessEnabled
    /**
     * The date and time the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The IAM role that registered a resource.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Whether or not the resource is a federated resource.
     */
    public val withFederation: kotlin.Boolean? = builder.withFederation
    /**
     * Grants the calling principal the permissions to perform all supported Lake Formation operations on the registered data location.
     */
    public val withPrivilegedAccess: kotlin.Boolean? = builder.withPrivilegedAccess

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.ResourceInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceInfo(")
        append("hybridAccessEnabled=$hybridAccessEnabled,")
        append("lastModified=$lastModified,")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn,")
        append("withFederation=$withFederation,")
        append("withPrivilegedAccess=$withPrivilegedAccess")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hybridAccessEnabled?.hashCode() ?: 0
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (withFederation?.hashCode() ?: 0)
        result = 31 * result + (withPrivilegedAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceInfo

        if (hybridAccessEnabled != other.hybridAccessEnabled) return false
        if (lastModified != other.lastModified) return false
        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false
        if (withFederation != other.withFederation) return false
        if (withPrivilegedAccess != other.withPrivilegedAccess) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.ResourceInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
         */
        public var hybridAccessEnabled: kotlin.Boolean? = null
        /**
         * The date and time the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The IAM role that registered a resource.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Whether or not the resource is a federated resource.
         */
        public var withFederation: kotlin.Boolean? = null
        /**
         * Grants the calling principal the permissions to perform all supported Lake Formation operations on the registered data location.
         */
        public var withPrivilegedAccess: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.ResourceInfo) : this() {
            this.hybridAccessEnabled = x.hybridAccessEnabled
            this.lastModified = x.lastModified
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
            this.withFederation = x.withFederation
            this.withPrivilegedAccess = x.withPrivilegedAccess
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.ResourceInfo = ResourceInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
