// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake Formation generated authorization identifier and information from the request's authorization context.
 */
public class QuerySessionContext private constructor(builder: Builder) {
    /**
     * An opaque string-string map passed by the query engine.
     */
    public val additionalContext: Map<String, String>? = builder.additionalContext
    /**
     * An identifier string for the consumer cluster.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     */
    public val queryAuthorizationId: kotlin.String? = builder.queryAuthorizationId
    /**
     * A unique identifier generated by the query engine for the query.
     */
    public val queryId: kotlin.String? = builder.queryId
    /**
     * A timestamp provided by the query engine for when the query started.
     */
    public val queryStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.queryStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.QuerySessionContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuerySessionContext(")
        append("additionalContext=$additionalContext,")
        append("clusterId=$clusterId,")
        append("queryAuthorizationId=$queryAuthorizationId,")
        append("queryId=$queryId,")
        append("queryStartTime=$queryStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalContext?.hashCode() ?: 0
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (queryAuthorizationId?.hashCode() ?: 0)
        result = 31 * result + (queryId?.hashCode() ?: 0)
        result = 31 * result + (queryStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuerySessionContext

        if (additionalContext != other.additionalContext) return false
        if (clusterId != other.clusterId) return false
        if (queryAuthorizationId != other.queryAuthorizationId) return false
        if (queryId != other.queryId) return false
        if (queryStartTime != other.queryStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.QuerySessionContext = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An opaque string-string map passed by the query engine.
         */
        public var additionalContext: Map<String, String>? = null
        /**
         * An identifier string for the consumer cluster.
         */
        public var clusterId: kotlin.String? = null
        /**
         * A cryptographically generated query identifier generated by Glue or Lake Formation.
         */
        public var queryAuthorizationId: kotlin.String? = null
        /**
         * A unique identifier generated by the query engine for the query.
         */
        public var queryId: kotlin.String? = null
        /**
         * A timestamp provided by the query engine for when the query started.
         */
        public var queryStartTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.QuerySessionContext) : this() {
            this.additionalContext = x.additionalContext
            this.clusterId = x.clusterId
            this.queryAuthorizationId = x.queryAuthorizationId
            this.queryId = x.queryId
            this.queryStartTime = x.queryStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.QuerySessionContext = QuerySessionContext(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
