// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure containing a list of LF-tag conditions or saved LF-Tag expressions that apply to a resource's LF-tag policy.
 */
public class LfTagPolicyResource private constructor(builder: Builder) {
    /**
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * A list of LF-tag conditions or a saved expression that apply to the resource's LF-tag policy.
     */
    public val expression: List<LfTag> = builder.expression
    /**
     * If provided, permissions are granted to the Data Catalog resources whose assigned LF-Tags match the expression body of the saved expression under the provided `ExpressionName`.
     */
    public val expressionName: kotlin.String? = builder.expressionName
    /**
     * The resource type for which the LF-tag policy applies.
     */
    public val resourceType: aws.sdk.kotlin.services.lakeformation.model.ResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.LfTagPolicyResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LfTagPolicyResource(")
        append("catalogId=$catalogId,")
        append("expression=$expression,")
        append("expressionName=$expressionName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (expression.hashCode())
        result = 31 * result + (expressionName?.hashCode() ?: 0)
        result = 31 * result + (resourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LfTagPolicyResource

        if (catalogId != other.catalogId) return false
        if (expression != other.expression) return false
        if (expressionName != other.expressionName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.LfTagPolicyResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
         */
        public var catalogId: kotlin.String? = null
        /**
         * A list of LF-tag conditions or a saved expression that apply to the resource's LF-tag policy.
         */
        public var expression: List<LfTag> = listOf()
        /**
         * If provided, permissions are granted to the Data Catalog resources whose assigned LF-Tags match the expression body of the saved expression under the provided `ExpressionName`.
         */
        public var expressionName: kotlin.String? = null
        /**
         * The resource type for which the LF-tag policy applies.
         */
        public var resourceType: aws.sdk.kotlin.services.lakeformation.model.ResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.LfTagPolicyResource) : this() {
            this.catalogId = x.catalogId
            this.expression = x.expression
            this.expressionName = x.expressionName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.LfTagPolicyResource = LfTagPolicyResource(this)

        internal fun correctErrors(): Builder {
            if (resourceType == null) resourceType = ResourceType.SdkUnknown("no value provided")
            return this
        }
    }
}
