// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetTableObjectsRequest private constructor(builder: Builder) {
    /**
     * The catalog containing the governed table. Defaults to the caller’s account.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * The database containing the governed table.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Specifies how many values to return in a page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A continuation token if this is not the first call to retrieve these objects.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A predicate to filter the objects returned based on the partition keys defined in the governed table.
     * + The comparison operators supported are: =, >, <, >=, <=
     * + The logical operators supported are: AND
     * + The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
     */
    public val partitionPredicate: kotlin.String? = builder.partitionPredicate
    /**
     * The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with `TransactionId`.
     */
    public val queryAsOfTime: aws.smithy.kotlin.runtime.time.Instant? = builder.queryAsOfTime
    /**
     * The governed table for which to retrieve objects.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with `QueryAsOfTime`.
     */
    public val transactionId: kotlin.String? = builder.transactionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetTableObjectsRequest(")
        append("catalogId=$catalogId,")
        append("databaseName=$databaseName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("partitionPredicate=$partitionPredicate,")
        append("queryAsOfTime=$queryAsOfTime,")
        append("tableName=$tableName,")
        append("transactionId=$transactionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (partitionPredicate?.hashCode() ?: 0)
        result = 31 * result + (queryAsOfTime?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetTableObjectsRequest

        if (catalogId != other.catalogId) return false
        if (databaseName != other.databaseName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (partitionPredicate != other.partitionPredicate) return false
        if (queryAsOfTime != other.queryAsOfTime) return false
        if (tableName != other.tableName) return false
        if (transactionId != other.transactionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The catalog containing the governed table. Defaults to the caller’s account.
         */
        public var catalogId: kotlin.String? = null
        /**
         * The database containing the governed table.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Specifies how many values to return in a page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A continuation token if this is not the first call to retrieve these objects.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A predicate to filter the objects returned based on the partition keys defined in the governed table.
         * + The comparison operators supported are: =, >, <, >=, <=
         * + The logical operators supported are: AND
         * + The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
         */
        public var partitionPredicate: kotlin.String? = null
        /**
         * The time as of when to read the governed table contents. If not set, the most recent transaction commit time is used. Cannot be specified along with `TransactionId`.
         */
        public var queryAsOfTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The governed table for which to retrieve objects.
         */
        public var tableName: kotlin.String? = null
        /**
         * The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with `QueryAsOfTime`.
         */
        public var transactionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest) : this() {
            this.catalogId = x.catalogId
            this.databaseName = x.databaseName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.partitionPredicate = x.partitionPredicate
            this.queryAsOfTime = x.queryAsOfTime
            this.tableName = x.tableName
            this.transactionId = x.transactionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest = GetTableObjectsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
