// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure representing a list of Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
 */
public class DataLakeSettings private constructor(builder: Builder) {
    /**
     * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     *
     * If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with Lake Formation.
     *
     * If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are registered with Lake Formation.
     *
     * For more information, see [(Optional) Allow external data filtering](https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter).
     */
    public val allowExternalDataFiltering: kotlin.Boolean? = builder.allowExternalDataFiltering
    /**
     * Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
     */
    public val allowFullTableExternalDataAccess: kotlin.Boolean? = builder.allowFullTableExternalDataAccess
    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation's administrative APIs.
     */
    public val authorizedSessionTagValueList: List<String>? = builder.authorizedSessionTagValueList
    /**
     * Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
     *
     * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.
     *
     * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
     *
     * For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
     */
    public val createDatabaseDefaultPermissions: List<PrincipalPermissions>? = builder.createDatabaseDefaultPermissions
    /**
     * Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
     *
     * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.
     *
     * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
     *
     * For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
     */
    public val createTableDefaultPermissions: List<PrincipalPermissions>? = builder.createTableDefaultPermissions
    /**
     * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
     */
    public val dataLakeAdmins: List<DataLakePrincipal>? = builder.dataLakeAdmins
    /**
     * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.>
     */
    public val externalDataFilteringAllowList: List<DataLakePrincipal>? = builder.externalDataFilteringAllowList
    /**
     * A key-value map that provides an additional configuration on your data lake. CROSS_ACCOUNT_VERSION is the key you can configure in the Parameters field. Accepted values for the CrossAccountVersion key are 1, 2, 3, and 4.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * A list of Lake Formation principals with only view access to the resources, without the ability to make changes. Supported principals are IAM users or IAM roles.
     */
    public val readOnlyAdmins: List<DataLakePrincipal>? = builder.readOnlyAdmins
    /**
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.
     *
     * You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     */
    public val trustedResourceOwners: List<String>? = builder.trustedResourceOwners

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.DataLakeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeSettings(")
        append("allowExternalDataFiltering=$allowExternalDataFiltering,")
        append("allowFullTableExternalDataAccess=$allowFullTableExternalDataAccess,")
        append("authorizedSessionTagValueList=$authorizedSessionTagValueList,")
        append("createDatabaseDefaultPermissions=$createDatabaseDefaultPermissions,")
        append("createTableDefaultPermissions=$createTableDefaultPermissions,")
        append("dataLakeAdmins=$dataLakeAdmins,")
        append("externalDataFilteringAllowList=$externalDataFilteringAllowList,")
        append("parameters=$parameters,")
        append("readOnlyAdmins=$readOnlyAdmins,")
        append("trustedResourceOwners=$trustedResourceOwners")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowExternalDataFiltering?.hashCode() ?: 0
        result = 31 * result + (allowFullTableExternalDataAccess?.hashCode() ?: 0)
        result = 31 * result + (authorizedSessionTagValueList?.hashCode() ?: 0)
        result = 31 * result + (createDatabaseDefaultPermissions?.hashCode() ?: 0)
        result = 31 * result + (createTableDefaultPermissions?.hashCode() ?: 0)
        result = 31 * result + (dataLakeAdmins?.hashCode() ?: 0)
        result = 31 * result + (externalDataFilteringAllowList?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (readOnlyAdmins?.hashCode() ?: 0)
        result = 31 * result + (trustedResourceOwners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeSettings

        if (allowExternalDataFiltering != other.allowExternalDataFiltering) return false
        if (allowFullTableExternalDataAccess != other.allowFullTableExternalDataAccess) return false
        if (authorizedSessionTagValueList != other.authorizedSessionTagValueList) return false
        if (createDatabaseDefaultPermissions != other.createDatabaseDefaultPermissions) return false
        if (createTableDefaultPermissions != other.createTableDefaultPermissions) return false
        if (dataLakeAdmins != other.dataLakeAdmins) return false
        if (externalDataFilteringAllowList != other.externalDataFilteringAllowList) return false
        if (parameters != other.parameters) return false
        if (readOnlyAdmins != other.readOnlyAdmins) return false
        if (trustedResourceOwners != other.trustedResourceOwners) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.DataLakeSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
         *
         * If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with Lake Formation.
         *
         * If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are registered with Lake Formation.
         *
         * For more information, see [(Optional) Allow external data filtering](https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter).
         */
        public var allowExternalDataFiltering: kotlin.Boolean? = null
        /**
         * Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
         */
        public var allowFullTableExternalDataAccess: kotlin.Boolean? = null
        /**
         * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation's administrative APIs.
         */
        public var authorizedSessionTagValueList: List<String>? = null
        /**
         * Specifies whether access control on newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
         *
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.
         *
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
         *
         * For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
         */
        public var createDatabaseDefaultPermissions: List<PrincipalPermissions>? = null
        /**
         * Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
         *
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by IAM permissions.
         *
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
         *
         * For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
         */
        public var createTableDefaultPermissions: List<PrincipalPermissions>? = null
        /**
         * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         */
        public var dataLakeAdmins: List<DataLakePrincipal>? = null
        /**
         * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.>
         */
        public var externalDataFilteringAllowList: List<DataLakePrincipal>? = null
        /**
         * A key-value map that provides an additional configuration on your data lake. CROSS_ACCOUNT_VERSION is the key you can configure in the Parameters field. Accepted values for the CrossAccountVersion key are 1, 2, 3, and 4.
         */
        public var parameters: Map<String, String>? = null
        /**
         * A list of Lake Formation principals with only view access to the resources, without the ability to make changes. Supported principals are IAM users or IAM roles.
         */
        public var readOnlyAdmins: List<DataLakePrincipal>? = null
        /**
         * A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.
         *
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
         */
        public var trustedResourceOwners: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.DataLakeSettings) : this() {
            this.allowExternalDataFiltering = x.allowExternalDataFiltering
            this.allowFullTableExternalDataAccess = x.allowFullTableExternalDataAccess
            this.authorizedSessionTagValueList = x.authorizedSessionTagValueList
            this.createDatabaseDefaultPermissions = x.createDatabaseDefaultPermissions
            this.createTableDefaultPermissions = x.createTableDefaultPermissions
            this.dataLakeAdmins = x.dataLakeAdmins
            this.externalDataFilteringAllowList = x.externalDataFilteringAllowList
            this.parameters = x.parameters
            this.readOnlyAdmins = x.readOnlyAdmins
            this.trustedResourceOwners = x.trustedResourceOwners
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.DataLakeSettings = DataLakeSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
