// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.lakeformation.auth.DefaultLakeFormationAuthSchemeProvider
import aws.sdk.kotlin.services.lakeformation.auth.LakeFormationAuthSchemeProvider
import aws.sdk.kotlin.services.lakeformation.endpoints.DefaultLakeFormationEndpointProvider
import aws.sdk.kotlin.services.lakeformation.endpoints.LakeFormationEndpointParameters
import aws.sdk.kotlin.services.lakeformation.endpoints.LakeFormationEndpointProvider
import aws.sdk.kotlin.services.lakeformation.model.AddLfTagsToResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.AddLfTagsToResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest
import aws.sdk.kotlin.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse
import aws.sdk.kotlin.services.lakeformation.model.BatchGrantPermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.BatchGrantPermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.BatchRevokePermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.BatchRevokePermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.CancelTransactionRequest
import aws.sdk.kotlin.services.lakeformation.model.CancelTransactionResponse
import aws.sdk.kotlin.services.lakeformation.model.CommitTransactionRequest
import aws.sdk.kotlin.services.lakeformation.model.CommitTransactionResponse
import aws.sdk.kotlin.services.lakeformation.model.CreateDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.CreateDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationRequest
import aws.sdk.kotlin.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationResponse
import aws.sdk.kotlin.services.lakeformation.model.CreateLakeFormationOptInRequest
import aws.sdk.kotlin.services.lakeformation.model.CreateLakeFormationOptInResponse
import aws.sdk.kotlin.services.lakeformation.model.CreateLfTagExpressionRequest
import aws.sdk.kotlin.services.lakeformation.model.CreateLfTagExpressionResponse
import aws.sdk.kotlin.services.lakeformation.model.CreateLfTagRequest
import aws.sdk.kotlin.services.lakeformation.model.CreateLfTagResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteLakeFormationOptInRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteLakeFormationOptInResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteLfTagExpressionRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteLfTagExpressionResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteLfTagRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteLfTagResponse
import aws.sdk.kotlin.services.lakeformation.model.DeleteObjectsOnCancelRequest
import aws.sdk.kotlin.services.lakeformation.model.DeleteObjectsOnCancelResponse
import aws.sdk.kotlin.services.lakeformation.model.DeregisterResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.DeregisterResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationRequest
import aws.sdk.kotlin.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse
import aws.sdk.kotlin.services.lakeformation.model.DescribeResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.DescribeResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.DescribeTransactionRequest
import aws.sdk.kotlin.services.lakeformation.model.DescribeTransactionResponse
import aws.sdk.kotlin.services.lakeformation.model.ExtendTransactionRequest
import aws.sdk.kotlin.services.lakeformation.model.ExtendTransactionResponse
import aws.sdk.kotlin.services.lakeformation.model.GetDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.GetDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.GetDataLakePrincipalRequest
import aws.sdk.kotlin.services.lakeformation.model.GetDataLakePrincipalResponse
import aws.sdk.kotlin.services.lakeformation.model.GetDataLakeSettingsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetDataLakeSettingsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetEffectivePermissionsForPathRequest
import aws.sdk.kotlin.services.lakeformation.model.GetEffectivePermissionsForPathResponse
import aws.sdk.kotlin.services.lakeformation.model.GetLfTagExpressionRequest
import aws.sdk.kotlin.services.lakeformation.model.GetLfTagExpressionResponse
import aws.sdk.kotlin.services.lakeformation.model.GetLfTagRequest
import aws.sdk.kotlin.services.lakeformation.model.GetLfTagResponse
import aws.sdk.kotlin.services.lakeformation.model.GetQueryStateRequest
import aws.sdk.kotlin.services.lakeformation.model.GetQueryStateResponse
import aws.sdk.kotlin.services.lakeformation.model.GetQueryStatisticsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetQueryStatisticsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetResourceLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetResourceLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetTableObjectsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitResultsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitResultsResponse
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitsRequest
import aws.sdk.kotlin.services.lakeformation.model.GetWorkUnitsResponse
import aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.ListDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLakeFormationOptInsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLakeFormationOptInsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagExpressionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagExpressionsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListPermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListPermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.ListResourcesRequest
import aws.sdk.kotlin.services.lakeformation.model.ListResourcesResponse
import aws.sdk.kotlin.services.lakeformation.model.ListTableStorageOptimizersRequest
import aws.sdk.kotlin.services.lakeformation.model.ListTableStorageOptimizersResponse
import aws.sdk.kotlin.services.lakeformation.model.ListTransactionsRequest
import aws.sdk.kotlin.services.lakeformation.model.ListTransactionsResponse
import aws.sdk.kotlin.services.lakeformation.model.PutDataLakeSettingsRequest
import aws.sdk.kotlin.services.lakeformation.model.PutDataLakeSettingsResponse
import aws.sdk.kotlin.services.lakeformation.model.RegisterResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.RegisterResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.RemoveLfTagsFromResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.RemoveLfTagsFromResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.RevokePermissionsRequest
import aws.sdk.kotlin.services.lakeformation.model.RevokePermissionsResponse
import aws.sdk.kotlin.services.lakeformation.model.SearchDatabasesByLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.SearchDatabasesByLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.SearchTablesByLfTagsRequest
import aws.sdk.kotlin.services.lakeformation.model.SearchTablesByLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.StartQueryPlanningRequest
import aws.sdk.kotlin.services.lakeformation.model.StartQueryPlanningResponse
import aws.sdk.kotlin.services.lakeformation.model.StartTransactionRequest
import aws.sdk.kotlin.services.lakeformation.model.StartTransactionResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateDataCellsFilterRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateDataCellsFilterResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateLfTagExpressionRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateLfTagExpressionResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateLfTagRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateLfTagResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateResourceRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateResourceResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateTableObjectsRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateTableObjectsResponse
import aws.sdk.kotlin.services.lakeformation.model.UpdateTableStorageOptimizerRequest
import aws.sdk.kotlin.services.lakeformation.model.UpdateTableStorageOptimizerResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "LakeFormation"
public const val SdkVersion: String = "1.5.19"
public const val ServiceApiVersion: String = "2017-03-31"

/**
 * # Lake Formation
 * Defines the public endpoint for the Lake Formation service.
 */
public interface LakeFormationClient : SdkClient {
    /**
     * LakeFormationClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LakeFormationClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "LakeFormation",
                "LAKEFORMATION",
                "lakeformation",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LakeFormationClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LakeFormationClient = DefaultLakeFormationClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LakeFormationEndpointProvider = builder.endpointProvider ?: DefaultLakeFormationEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LakeFormationAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLakeFormationAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "LakeFormation"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LakeFormationEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LakeFormationAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Attaches one or more LF-tags to an existing resource.
     */
    public suspend fun addLfTagsToResource(input: AddLfTagsToResourceRequest): AddLfTagsToResourceResponse

    /**
     * Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML assertion included in the request. This decoration allows Lake Formation to enforce access policies against the SAML users and groups. This API operation requires SAML federation setup in the caller’s account as it can only be called with valid SAML assertions. Lake Formation does not scope down the permission of the assumed role. All permissions attached to the role via the SAML federation setup will be included in the role session.
     *
     *  This decorated role is expected to access data in Amazon S3 by getting temporary access from Lake Formation which is authorized via the virtual API `GetDataAccess`. Therefore, all SAML roles that can be assumed via `AssumeDecoratedRoleWithSAML` must at a minimum include `lakeformation:GetDataAccess` in their role policies. A typical IAM policy attached to such a role would look as follows:
     */
    public suspend fun assumeDecoratedRoleWithSaml(input: AssumeDecoratedRoleWithSamlRequest): AssumeDecoratedRoleWithSamlResponse

    /**
     * Batch operation to grant permissions to the principal.
     */
    public suspend fun batchGrantPermissions(input: BatchGrantPermissionsRequest): BatchGrantPermissionsResponse

    /**
     * Batch operation to revoke permissions from the principal.
     */
    public suspend fun batchRevokePermissions(input: BatchRevokePermissionsRequest): BatchRevokePermissionsResponse

    /**
     * Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.
     */
    public suspend fun cancelTransaction(input: CancelTransactionRequest): CancelTransactionResponse

    /**
     * Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted. This API action is idempotent if called multiple times for the same transaction.
     */
    public suspend fun commitTransaction(input: CommitTransactionRequest): CommitTransactionResponse

    /**
     * Creates a data cell filter to allow one to grant access to certain columns on certain rows.
     */
    public suspend fun createDataCellsFilter(input: CreateDataCellsFilterRequest): CreateDataCellsFilterResponse

    /**
     * Creates an IAM Identity Center connection with Lake Formation to allow IAM Identity Center users and groups to access Data Catalog resources.
     */
    public suspend fun createLakeFormationIdentityCenterConfiguration(input: CreateLakeFormationIdentityCenterConfigurationRequest = CreateLakeFormationIdentityCenterConfigurationRequest { }): CreateLakeFormationIdentityCenterConfigurationResponse

    /**
     * Enforce Lake Formation permissions for the given databases, tables, and principals.
     */
    public suspend fun createLakeFormationOptIn(input: CreateLakeFormationOptInRequest): CreateLakeFormationOptInResponse

    /**
     * Creates an LF-tag with the specified name and values.
     */
    public suspend fun createLfTag(input: CreateLfTagRequest): CreateLfTagResponse

    /**
     * Creates a new LF-Tag expression with the provided name, description, catalog ID, and expression body. This call fails if a LF-Tag expression with the same name already exists in the caller’s account or if the underlying LF-Tags don't exist. To call this API operation, caller needs the following Lake Formation permissions:
     *
     * `CREATE_LF_TAG_EXPRESSION` on the root catalog resource.
     *
     * `GRANT_WITH_LF_TAG_EXPRESSION` on all underlying LF-Tag key:value pairs included in the expression.
     */
    public suspend fun createLfTagExpression(input: CreateLfTagExpressionRequest): CreateLfTagExpressionResponse

    /**
     * Deletes a data cell filter.
     */
    public suspend fun deleteDataCellsFilter(input: DeleteDataCellsFilterRequest = DeleteDataCellsFilterRequest { }): DeleteDataCellsFilterResponse

    /**
     * Deletes an IAM Identity Center connection with Lake Formation.
     */
    public suspend fun deleteLakeFormationIdentityCenterConfiguration(input: DeleteLakeFormationIdentityCenterConfigurationRequest = DeleteLakeFormationIdentityCenterConfigurationRequest { }): DeleteLakeFormationIdentityCenterConfigurationResponse

    /**
     * Remove the Lake Formation permissions enforcement of the given databases, tables, and principals.
     */
    public suspend fun deleteLakeFormationOptIn(input: DeleteLakeFormationOptInRequest): DeleteLakeFormationOptInResponse

    /**
     * Deletes the specified LF-tag given a key name. If the input parameter tag key was not found, then the operation will throw an exception. When you delete an LF-tag, the `LFTagPolicy` attached to the LF-tag becomes invalid. If the deleted LF-tag was still assigned to any resource, the tag policy attach to the deleted LF-tag will no longer be applied to the resource.
     */
    public suspend fun deleteLfTag(input: DeleteLfTagRequest): DeleteLfTagResponse

    /**
     * Deletes the LF-Tag expression. The caller must be a data lake admin or have `DROP` permissions on the LF-Tag expression. Deleting a LF-Tag expression will also delete all `LFTagPolicy` permissions referencing the LF-Tag expression.
     */
    public suspend fun deleteLfTagExpression(input: DeleteLfTagExpressionRequest): DeleteLfTagExpressionResponse

    /**
     * For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels.
     *
     *  The Glue ETL library function `write_dynamic_frame.from_catalog()` includes an option to automatically call `DeleteObjectsOnCancel` before writes. For more information, see [Rolling Back Amazon S3 Writes](https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes).
     */
    public suspend fun deleteObjectsOnCancel(input: DeleteObjectsOnCancelRequest): DeleteObjectsOnCancelResponse

    /**
     * Deregisters the resource as managed by the Data Catalog.
     *
     * When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.
     */
    public suspend fun deregisterResource(input: DeregisterResourceRequest): DeregisterResourceResponse

    /**
     * Retrieves the instance ARN and application ARN for the connection.
     */
    public suspend fun describeLakeFormationIdentityCenterConfiguration(input: DescribeLakeFormationIdentityCenterConfigurationRequest = DescribeLakeFormationIdentityCenterConfigurationRequest { }): DescribeLakeFormationIdentityCenterConfigurationResponse

    /**
     * Retrieves the current data access role for the given resource registered in Lake Formation.
     */
    public suspend fun describeResource(input: DescribeResourceRequest): DescribeResourceResponse

    /**
     * Returns the details of a single transaction.
     */
    public suspend fun describeTransaction(input: DescribeTransactionRequest): DescribeTransactionResponse

    /**
     * Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted.
     *
     * Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.
     */
    public suspend fun extendTransaction(input: ExtendTransactionRequest = ExtendTransactionRequest { }): ExtendTransactionResponse

    /**
     * Returns a data cells filter.
     */
    public suspend fun getDataCellsFilter(input: GetDataCellsFilterRequest): GetDataCellsFilterResponse

    /**
     * Returns the identity of the invoking principal.
     */
    public suspend fun getDataLakePrincipal(input: GetDataLakePrincipalRequest = GetDataLakePrincipalRequest { }): GetDataLakePrincipalResponse

    /**
     * Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.
     */
    public suspend fun getDataLakeSettings(input: GetDataLakeSettingsRequest = GetDataLakeSettingsRequest { }): GetDataLakeSettingsResponse

    /**
     * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. `GetEffectivePermissionsForPath` will not return databases and tables if the catalog is encrypted.
     */
    public suspend fun getEffectivePermissionsForPath(input: GetEffectivePermissionsForPathRequest): GetEffectivePermissionsForPathResponse

    /**
     * Returns an LF-tag definition.
     */
    public suspend fun getLfTag(input: GetLfTagRequest): GetLfTagResponse

    /**
     * Returns the details about the LF-Tag expression. The caller must be a data lake admin or must have `DESCRIBE` permission on the LF-Tag expression resource.
     */
    public suspend fun getLfTagExpression(input: GetLfTagExpressionRequest): GetLfTagExpressionResponse

    /**
     * Returns the state of a query previously submitted. Clients are expected to poll `GetQueryState` to monitor the current state of the planning before retrieving the work units. A query state is only visible to the principal that made the initial call to `StartQueryPlanning`.
     */
    public suspend fun getQueryState(input: GetQueryStateRequest): GetQueryStateResponse

    /**
     * Retrieves statistics on the planning and execution of a query.
     */
    public suspend fun getQueryStatistics(input: GetQueryStatisticsRequest): GetQueryStatisticsResponse

    /**
     * Returns the LF-tags applied to a resource.
     */
    public suspend fun getResourceLfTags(input: GetResourceLfTagsRequest): GetResourceLfTagsResponse

    /**
     * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.
     */
    public suspend fun getTableObjects(input: GetTableObjectsRequest): GetTableObjectsResponse

    /**
     * This API is identical to `GetTemporaryTableCredentials` except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.
     */
    public suspend fun getTemporaryGluePartitionCredentials(input: GetTemporaryGluePartitionCredentialsRequest): GetTemporaryGluePartitionCredentialsResponse

    /**
     * Allows a caller in a secure environment to assume a role with permission to access Amazon S3. In order to vend such credentials, Lake Formation assumes the role associated with a registered location, for example an Amazon S3 bucket, with a scope down policy which restricts the access to a single prefix.
     *
     * To call this API, the role that the service assumes must have `lakeformation:GetDataAccess` permission on the resource.
     */
    public suspend fun getTemporaryGlueTableCredentials(input: GetTemporaryGlueTableCredentialsRequest): GetTemporaryGlueTableCredentialsResponse

    /**
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     */
    public suspend fun <T> getWorkUnitResults(input: GetWorkUnitResultsRequest, block: suspend (GetWorkUnitResultsResponse) -> T): T

    /**
     * Retrieves the work units generated by the `StartQueryPlanning` operation.
     */
    public suspend fun getWorkUnits(input: GetWorkUnitsRequest): GetWorkUnitsResponse

    /**
     * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
     *
     * For information about permissions, see [Security and Access Control to Metadata and Data](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
     */
    public suspend fun grantPermissions(input: GrantPermissionsRequest): GrantPermissionsResponse

    /**
     * Lists all the data cell filters on a table.
     */
    public suspend fun listDataCellsFilter(input: ListDataCellsFilterRequest = ListDataCellsFilterRequest { }): ListDataCellsFilterResponse

    /**
     * Retrieve the current list of resources and principals that are opt in to enforce Lake Formation permissions.
     */
    public suspend fun listLakeFormationOptIns(input: ListLakeFormationOptInsRequest = ListLakeFormationOptInsRequest { }): ListLakeFormationOptInsResponse

    /**
     * Returns the LF-Tag expressions in caller’s account filtered based on caller's permissions. Data Lake and read only admins implicitly can see all tag expressions in their account, else caller needs DESCRIBE permissions on tag expression.
     */
    public suspend fun listLfTagExpressions(input: ListLfTagExpressionsRequest = ListLfTagExpressionsRequest { }): ListLfTagExpressionsResponse

    /**
     * Lists LF-tags that the requester has permission to view.
     */
    public suspend fun listLfTags(input: ListLfTagsRequest = ListLfTagsRequest { }): ListLfTagsResponse

    /**
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     *
     * This operation returns only those permissions that have been explicitly granted.
     *
     * For information about permissions, see [Security and Access Control to Metadata and Data](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
     */
    public suspend fun listPermissions(input: ListPermissionsRequest = ListPermissionsRequest { }): ListPermissionsResponse

    /**
     * Lists the resources registered to be managed by the Data Catalog.
     */
    public suspend fun listResources(input: ListResourcesRequest = ListResourcesRequest { }): ListResourcesResponse

    /**
     * Returns the configuration of all storage optimizers associated with a specified table.
     */
    public suspend fun listTableStorageOptimizers(input: ListTableStorageOptimizersRequest): ListTableStorageOptimizersResponse

    /**
     * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.
     *
     * This operation can help you identify uncommitted transactions or to get information about transactions.
     */
    public suspend fun listTransactions(input: ListTransactionsRequest = ListTransactionsRequest { }): ListTransactionsResponse

    /**
     * Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see [Granting Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html).
     *
     * This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.
     */
    public suspend fun putDataLakeSettings(input: PutDataLakeSettingsRequest): PutDataLakeSettingsResponse

    /**
     * Registers the resource as managed by the Data Catalog.
     *
     * To add or update data, Lake Formation needs read/write access to the chosen data location. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.
     *
     * The following request registers a new location and gives Lake Formation permission to use the service-linked role to access that location.
     *
     * `ResourceArn = arn:aws:s3:::my-bucket/ UseServiceLinkedRole = true`
     *
     * If `UseServiceLinkedRole` is not set to true, you must provide or set the `RoleArn`:
     *
     * `arn:aws:iam::12345:role/my-data-access-role`
     */
    public suspend fun registerResource(input: RegisterResourceRequest): RegisterResourceResponse

    /**
     * Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in `tableWithColumns` to specify column input.
     */
    public suspend fun removeLfTagsFromResource(input: RemoveLfTagsFromResourceRequest): RemoveLfTagsFromResourceResponse

    /**
     * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
     */
    public suspend fun revokePermissions(input: RevokePermissionsRequest): RevokePermissionsResponse

    /**
     * This operation allows a search on `DATABASE` resources by `TagCondition`. This operation is used by admins who want to grant user permissions on certain `TagConditions`. Before making a grant, the admin can use `SearchDatabasesByTags` to find all resources where the given `TagConditions` are valid to verify whether the returned resources can be shared.
     */
    public suspend fun searchDatabasesByLfTags(input: SearchDatabasesByLfTagsRequest): SearchDatabasesByLfTagsResponse

    /**
     * This operation allows a search on `TABLE` resources by `LFTag`s. This will be used by admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use `SearchTablesByLFTags` to find all resources where the given `LFTag`s are valid to verify whether the returned resources can be shared.
     */
    public suspend fun searchTablesByLfTags(input: SearchTablesByLfTagsRequest): SearchTablesByLfTagsResponse

    /**
     * Submits a request to process a query statement.
     *
     * This operation generates work units that can be retrieved with the `GetWorkUnits` operation as soon as the query state is WORKUNITS_AVAILABLE or FINISHED.
     */
    public suspend fun startQueryPlanning(input: StartQueryPlanningRequest): StartQueryPlanningResponse

    /**
     * Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to identify a transaction.
     */
    public suspend fun startTransaction(input: StartTransactionRequest = StartTransactionRequest { }): StartTransactionResponse

    /**
     * Updates a data cell filter.
     */
    public suspend fun updateDataCellsFilter(input: UpdateDataCellsFilterRequest): UpdateDataCellsFilterResponse

    /**
     * Updates the IAM Identity Center connection parameters.
     */
    public suspend fun updateLakeFormationIdentityCenterConfiguration(input: UpdateLakeFormationIdentityCenterConfigurationRequest = UpdateLakeFormationIdentityCenterConfigurationRequest { }): UpdateLakeFormationIdentityCenterConfigurationResponse

    /**
     * Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.
     */
    public suspend fun updateLfTag(input: UpdateLfTagRequest): UpdateLfTagResponse

    /**
     * Updates the name of the LF-Tag expression to the new description and expression body provided. Updating a LF-Tag expression immediately changes the permission boundaries of all existing `LFTagPolicy` permission grants that reference the given LF-Tag expression.
     */
    public suspend fun updateLfTagExpression(input: UpdateLfTagExpressionRequest): UpdateLfTagExpressionResponse

    /**
     * Updates the data access role used for vending access to the given (registered) resource in Lake Formation.
     */
    public suspend fun updateResource(input: UpdateResourceRequest): UpdateResourceResponse

    /**
     * Updates the manifest of Amazon S3 objects that make up the specified governed table.
     */
    public suspend fun updateTableObjects(input: UpdateTableObjectsRequest): UpdateTableObjectsResponse

    /**
     * Updates the configuration of the storage optimizers for a table.
     */
    public suspend fun updateTableStorageOptimizer(input: UpdateTableStorageOptimizerRequest): UpdateTableStorageOptimizerResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LakeFormationClient.withConfig(block: LakeFormationClient.Config.Builder.() -> Unit): LakeFormationClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLakeFormationClient(newConfig)
}

/**
 * Attaches one or more LF-tags to an existing resource.
 */
public suspend inline fun LakeFormationClient.addLfTagsToResource(crossinline block: AddLfTagsToResourceRequest.Builder.() -> Unit): AddLfTagsToResourceResponse = addLfTagsToResource(AddLfTagsToResourceRequest.Builder().apply(block).build())

/**
 * Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML assertion included in the request. This decoration allows Lake Formation to enforce access policies against the SAML users and groups. This API operation requires SAML federation setup in the caller’s account as it can only be called with valid SAML assertions. Lake Formation does not scope down the permission of the assumed role. All permissions attached to the role via the SAML federation setup will be included in the role session.
 *
 *  This decorated role is expected to access data in Amazon S3 by getting temporary access from Lake Formation which is authorized via the virtual API `GetDataAccess`. Therefore, all SAML roles that can be assumed via `AssumeDecoratedRoleWithSAML` must at a minimum include `lakeformation:GetDataAccess` in their role policies. A typical IAM policy attached to such a role would look as follows:
 */
public suspend inline fun LakeFormationClient.assumeDecoratedRoleWithSaml(crossinline block: AssumeDecoratedRoleWithSamlRequest.Builder.() -> Unit): AssumeDecoratedRoleWithSamlResponse = assumeDecoratedRoleWithSaml(AssumeDecoratedRoleWithSamlRequest.Builder().apply(block).build())

/**
 * Batch operation to grant permissions to the principal.
 */
public suspend inline fun LakeFormationClient.batchGrantPermissions(crossinline block: BatchGrantPermissionsRequest.Builder.() -> Unit): BatchGrantPermissionsResponse = batchGrantPermissions(BatchGrantPermissionsRequest.Builder().apply(block).build())

/**
 * Batch operation to revoke permissions from the principal.
 */
public suspend inline fun LakeFormationClient.batchRevokePermissions(crossinline block: BatchRevokePermissionsRequest.Builder.() -> Unit): BatchRevokePermissionsResponse = batchRevokePermissions(BatchRevokePermissionsRequest.Builder().apply(block).build())

/**
 * Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.
 */
public suspend inline fun LakeFormationClient.cancelTransaction(crossinline block: CancelTransactionRequest.Builder.() -> Unit): CancelTransactionResponse = cancelTransaction(CancelTransactionRequest.Builder().apply(block).build())

/**
 * Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted. This API action is idempotent if called multiple times for the same transaction.
 */
public suspend inline fun LakeFormationClient.commitTransaction(crossinline block: CommitTransactionRequest.Builder.() -> Unit): CommitTransactionResponse = commitTransaction(CommitTransactionRequest.Builder().apply(block).build())

/**
 * Creates a data cell filter to allow one to grant access to certain columns on certain rows.
 */
public suspend inline fun LakeFormationClient.createDataCellsFilter(crossinline block: CreateDataCellsFilterRequest.Builder.() -> Unit): CreateDataCellsFilterResponse = createDataCellsFilter(CreateDataCellsFilterRequest.Builder().apply(block).build())

/**
 * Creates an IAM Identity Center connection with Lake Formation to allow IAM Identity Center users and groups to access Data Catalog resources.
 */
public suspend inline fun LakeFormationClient.createLakeFormationIdentityCenterConfiguration(crossinline block: CreateLakeFormationIdentityCenterConfigurationRequest.Builder.() -> Unit): CreateLakeFormationIdentityCenterConfigurationResponse = createLakeFormationIdentityCenterConfiguration(CreateLakeFormationIdentityCenterConfigurationRequest.Builder().apply(block).build())

/**
 * Enforce Lake Formation permissions for the given databases, tables, and principals.
 */
public suspend inline fun LakeFormationClient.createLakeFormationOptIn(crossinline block: CreateLakeFormationOptInRequest.Builder.() -> Unit): CreateLakeFormationOptInResponse = createLakeFormationOptIn(CreateLakeFormationOptInRequest.Builder().apply(block).build())

/**
 * Creates an LF-tag with the specified name and values.
 */
public suspend inline fun LakeFormationClient.createLfTag(crossinline block: CreateLfTagRequest.Builder.() -> Unit): CreateLfTagResponse = createLfTag(CreateLfTagRequest.Builder().apply(block).build())

/**
 * Creates a new LF-Tag expression with the provided name, description, catalog ID, and expression body. This call fails if a LF-Tag expression with the same name already exists in the caller’s account or if the underlying LF-Tags don't exist. To call this API operation, caller needs the following Lake Formation permissions:
 *
 * `CREATE_LF_TAG_EXPRESSION` on the root catalog resource.
 *
 * `GRANT_WITH_LF_TAG_EXPRESSION` on all underlying LF-Tag key:value pairs included in the expression.
 */
public suspend inline fun LakeFormationClient.createLfTagExpression(crossinline block: CreateLfTagExpressionRequest.Builder.() -> Unit): CreateLfTagExpressionResponse = createLfTagExpression(CreateLfTagExpressionRequest.Builder().apply(block).build())

/**
 * Deletes a data cell filter.
 */
public suspend inline fun LakeFormationClient.deleteDataCellsFilter(crossinline block: DeleteDataCellsFilterRequest.Builder.() -> Unit): DeleteDataCellsFilterResponse = deleteDataCellsFilter(DeleteDataCellsFilterRequest.Builder().apply(block).build())

/**
 * Deletes an IAM Identity Center connection with Lake Formation.
 */
public suspend inline fun LakeFormationClient.deleteLakeFormationIdentityCenterConfiguration(crossinline block: DeleteLakeFormationIdentityCenterConfigurationRequest.Builder.() -> Unit): DeleteLakeFormationIdentityCenterConfigurationResponse = deleteLakeFormationIdentityCenterConfiguration(DeleteLakeFormationIdentityCenterConfigurationRequest.Builder().apply(block).build())

/**
 * Remove the Lake Formation permissions enforcement of the given databases, tables, and principals.
 */
public suspend inline fun LakeFormationClient.deleteLakeFormationOptIn(crossinline block: DeleteLakeFormationOptInRequest.Builder.() -> Unit): DeleteLakeFormationOptInResponse = deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest.Builder().apply(block).build())

/**
 * Deletes the specified LF-tag given a key name. If the input parameter tag key was not found, then the operation will throw an exception. When you delete an LF-tag, the `LFTagPolicy` attached to the LF-tag becomes invalid. If the deleted LF-tag was still assigned to any resource, the tag policy attach to the deleted LF-tag will no longer be applied to the resource.
 */
public suspend inline fun LakeFormationClient.deleteLfTag(crossinline block: DeleteLfTagRequest.Builder.() -> Unit): DeleteLfTagResponse = deleteLfTag(DeleteLfTagRequest.Builder().apply(block).build())

/**
 * Deletes the LF-Tag expression. The caller must be a data lake admin or have `DROP` permissions on the LF-Tag expression. Deleting a LF-Tag expression will also delete all `LFTagPolicy` permissions referencing the LF-Tag expression.
 */
public suspend inline fun LakeFormationClient.deleteLfTagExpression(crossinline block: DeleteLfTagExpressionRequest.Builder.() -> Unit): DeleteLfTagExpressionResponse = deleteLfTagExpression(DeleteLfTagExpressionRequest.Builder().apply(block).build())

/**
 * For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels.
 *
 *  The Glue ETL library function `write_dynamic_frame.from_catalog()` includes an option to automatically call `DeleteObjectsOnCancel` before writes. For more information, see [Rolling Back Amazon S3 Writes](https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes).
 */
public suspend inline fun LakeFormationClient.deleteObjectsOnCancel(crossinline block: DeleteObjectsOnCancelRequest.Builder.() -> Unit): DeleteObjectsOnCancelResponse = deleteObjectsOnCancel(DeleteObjectsOnCancelRequest.Builder().apply(block).build())

/**
 * Deregisters the resource as managed by the Data Catalog.
 *
 * When you deregister a path, Lake Formation removes the path from the inline policy attached to your service-linked role.
 */
public suspend inline fun LakeFormationClient.deregisterResource(crossinline block: DeregisterResourceRequest.Builder.() -> Unit): DeregisterResourceResponse = deregisterResource(DeregisterResourceRequest.Builder().apply(block).build())

/**
 * Retrieves the instance ARN and application ARN for the connection.
 */
public suspend inline fun LakeFormationClient.describeLakeFormationIdentityCenterConfiguration(crossinline block: DescribeLakeFormationIdentityCenterConfigurationRequest.Builder.() -> Unit): DescribeLakeFormationIdentityCenterConfigurationResponse = describeLakeFormationIdentityCenterConfiguration(DescribeLakeFormationIdentityCenterConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the current data access role for the given resource registered in Lake Formation.
 */
public suspend inline fun LakeFormationClient.describeResource(crossinline block: DescribeResourceRequest.Builder.() -> Unit): DescribeResourceResponse = describeResource(DescribeResourceRequest.Builder().apply(block).build())

/**
 * Returns the details of a single transaction.
 */
public suspend inline fun LakeFormationClient.describeTransaction(crossinline block: DescribeTransactionRequest.Builder.() -> Unit): DescribeTransactionResponse = describeTransaction(DescribeTransactionRequest.Builder().apply(block).build())

/**
 * Indicates to the service that the specified transaction is still active and should not be treated as idle and aborted.
 *
 * Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.
 */
public suspend inline fun LakeFormationClient.extendTransaction(crossinline block: ExtendTransactionRequest.Builder.() -> Unit): ExtendTransactionResponse = extendTransaction(ExtendTransactionRequest.Builder().apply(block).build())

/**
 * Returns a data cells filter.
 */
public suspend inline fun LakeFormationClient.getDataCellsFilter(crossinline block: GetDataCellsFilterRequest.Builder.() -> Unit): GetDataCellsFilterResponse = getDataCellsFilter(GetDataCellsFilterRequest.Builder().apply(block).build())

/**
 * Returns the identity of the invoking principal.
 */
public suspend inline fun LakeFormationClient.getDataLakePrincipal(crossinline block: GetDataLakePrincipalRequest.Builder.() -> Unit): GetDataLakePrincipalResponse = getDataLakePrincipal(GetDataLakePrincipalRequest.Builder().apply(block).build())

/**
 * Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.
 */
public suspend inline fun LakeFormationClient.getDataLakeSettings(crossinline block: GetDataLakeSettingsRequest.Builder.() -> Unit): GetDataLakeSettingsResponse = getDataLakeSettings(GetDataLakeSettingsRequest.Builder().apply(block).build())

/**
 * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3. `GetEffectivePermissionsForPath` will not return databases and tables if the catalog is encrypted.
 */
public suspend inline fun LakeFormationClient.getEffectivePermissionsForPath(crossinline block: GetEffectivePermissionsForPathRequest.Builder.() -> Unit): GetEffectivePermissionsForPathResponse = getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest.Builder().apply(block).build())

/**
 * Returns an LF-tag definition.
 */
public suspend inline fun LakeFormationClient.getLfTag(crossinline block: GetLfTagRequest.Builder.() -> Unit): GetLfTagResponse = getLfTag(GetLfTagRequest.Builder().apply(block).build())

/**
 * Returns the details about the LF-Tag expression. The caller must be a data lake admin or must have `DESCRIBE` permission on the LF-Tag expression resource.
 */
public suspend inline fun LakeFormationClient.getLfTagExpression(crossinline block: GetLfTagExpressionRequest.Builder.() -> Unit): GetLfTagExpressionResponse = getLfTagExpression(GetLfTagExpressionRequest.Builder().apply(block).build())

/**
 * Returns the state of a query previously submitted. Clients are expected to poll `GetQueryState` to monitor the current state of the planning before retrieving the work units. A query state is only visible to the principal that made the initial call to `StartQueryPlanning`.
 */
public suspend inline fun LakeFormationClient.getQueryState(crossinline block: GetQueryStateRequest.Builder.() -> Unit): GetQueryStateResponse = getQueryState(GetQueryStateRequest.Builder().apply(block).build())

/**
 * Retrieves statistics on the planning and execution of a query.
 */
public suspend inline fun LakeFormationClient.getQueryStatistics(crossinline block: GetQueryStatisticsRequest.Builder.() -> Unit): GetQueryStatisticsResponse = getQueryStatistics(GetQueryStatisticsRequest.Builder().apply(block).build())

/**
 * Returns the LF-tags applied to a resource.
 */
public suspend inline fun LakeFormationClient.getResourceLfTags(crossinline block: GetResourceLfTagsRequest.Builder.() -> Unit): GetResourceLfTagsResponse = getResourceLfTags(GetResourceLfTagsRequest.Builder().apply(block).build())

/**
 * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.
 */
public suspend inline fun LakeFormationClient.getTableObjects(crossinline block: GetTableObjectsRequest.Builder.() -> Unit): GetTableObjectsResponse = getTableObjects(GetTableObjectsRequest.Builder().apply(block).build())

/**
 * This API is identical to `GetTemporaryTableCredentials` except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.
 */
public suspend inline fun LakeFormationClient.getTemporaryGluePartitionCredentials(crossinline block: GetTemporaryGluePartitionCredentialsRequest.Builder.() -> Unit): GetTemporaryGluePartitionCredentialsResponse = getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest.Builder().apply(block).build())

/**
 * Allows a caller in a secure environment to assume a role with permission to access Amazon S3. In order to vend such credentials, Lake Formation assumes the role associated with a registered location, for example an Amazon S3 bucket, with a scope down policy which restricts the access to a single prefix.
 *
 * To call this API, the role that the service assumes must have `lakeformation:GetDataAccess` permission on the resource.
 */
public suspend inline fun LakeFormationClient.getTemporaryGlueTableCredentials(crossinline block: GetTemporaryGlueTableCredentialsRequest.Builder.() -> Unit): GetTemporaryGlueTableCredentialsResponse = getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest.Builder().apply(block).build())

/**
 * Retrieves the work units generated by the `StartQueryPlanning` operation.
 */
public suspend inline fun LakeFormationClient.getWorkUnits(crossinline block: GetWorkUnitsRequest.Builder.() -> Unit): GetWorkUnitsResponse = getWorkUnits(GetWorkUnitsRequest.Builder().apply(block).build())

/**
 * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
 *
 * For information about permissions, see [Security and Access Control to Metadata and Data](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
 */
public suspend inline fun LakeFormationClient.grantPermissions(crossinline block: GrantPermissionsRequest.Builder.() -> Unit): GrantPermissionsResponse = grantPermissions(GrantPermissionsRequest.Builder().apply(block).build())

/**
 * Lists all the data cell filters on a table.
 */
public suspend inline fun LakeFormationClient.listDataCellsFilter(crossinline block: ListDataCellsFilterRequest.Builder.() -> Unit): ListDataCellsFilterResponse = listDataCellsFilter(ListDataCellsFilterRequest.Builder().apply(block).build())

/**
 * Retrieve the current list of resources and principals that are opt in to enforce Lake Formation permissions.
 */
public suspend inline fun LakeFormationClient.listLakeFormationOptIns(crossinline block: ListLakeFormationOptInsRequest.Builder.() -> Unit): ListLakeFormationOptInsResponse = listLakeFormationOptIns(ListLakeFormationOptInsRequest.Builder().apply(block).build())

/**
 * Returns the LF-Tag expressions in caller’s account filtered based on caller's permissions. Data Lake and read only admins implicitly can see all tag expressions in their account, else caller needs DESCRIBE permissions on tag expression.
 */
public suspend inline fun LakeFormationClient.listLfTagExpressions(crossinline block: ListLfTagExpressionsRequest.Builder.() -> Unit): ListLfTagExpressionsResponse = listLfTagExpressions(ListLfTagExpressionsRequest.Builder().apply(block).build())

/**
 * Lists LF-tags that the requester has permission to view.
 */
public suspend inline fun LakeFormationClient.listLfTags(crossinline block: ListLfTagsRequest.Builder.() -> Unit): ListLfTagsResponse = listLfTags(ListLfTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
 *
 * This operation returns only those permissions that have been explicitly granted.
 *
 * For information about permissions, see [Security and Access Control to Metadata and Data](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
 */
public suspend inline fun LakeFormationClient.listPermissions(crossinline block: ListPermissionsRequest.Builder.() -> Unit): ListPermissionsResponse = listPermissions(ListPermissionsRequest.Builder().apply(block).build())

/**
 * Lists the resources registered to be managed by the Data Catalog.
 */
public suspend inline fun LakeFormationClient.listResources(crossinline block: ListResourcesRequest.Builder.() -> Unit): ListResourcesResponse = listResources(ListResourcesRequest.Builder().apply(block).build())

/**
 * Returns the configuration of all storage optimizers associated with a specified table.
 */
public suspend inline fun LakeFormationClient.listTableStorageOptimizers(crossinline block: ListTableStorageOptimizersRequest.Builder.() -> Unit): ListTableStorageOptimizersResponse = listTableStorageOptimizers(ListTableStorageOptimizersRequest.Builder().apply(block).build())

/**
 * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only uncommitted transactions and those available for time-travel queries are returned.
 *
 * This operation can help you identify uncommitted transactions or to get information about transactions.
 */
public suspend inline fun LakeFormationClient.listTransactions(crossinline block: ListTransactionsRequest.Builder.() -> Unit): ListTransactionsResponse = listTransactions(ListTransactionsRequest.Builder().apply(block).build())

/**
 * Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation. For more information on admin privileges, see [Granting Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html).
 *
 * This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the current list and add the new admin to that list and pass that list in this API.
 */
public suspend inline fun LakeFormationClient.putDataLakeSettings(crossinline block: PutDataLakeSettingsRequest.Builder.() -> Unit): PutDataLakeSettingsResponse = putDataLakeSettings(PutDataLakeSettingsRequest.Builder().apply(block).build())

/**
 * Registers the resource as managed by the Data Catalog.
 *
 * To add or update data, Lake Formation needs read/write access to the chosen data location. Choose a role that you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role. When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.
 *
 * The following request registers a new location and gives Lake Formation permission to use the service-linked role to access that location.
 *
 * `ResourceArn = arn:aws:s3:::my-bucket/ UseServiceLinkedRole = true`
 *
 * If `UseServiceLinkedRole` is not set to true, you must provide or set the `RoleArn`:
 *
 * `arn:aws:iam::12345:role/my-data-access-role`
 */
public suspend inline fun LakeFormationClient.registerResource(crossinline block: RegisterResourceRequest.Builder.() -> Unit): RegisterResourceResponse = registerResource(RegisterResourceRequest.Builder().apply(block).build())

/**
 * Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag columns, use the column inclusion list in `tableWithColumns` to specify column input.
 */
public suspend inline fun LakeFormationClient.removeLfTagsFromResource(crossinline block: RemoveLfTagsFromResourceRequest.Builder.() -> Unit): RemoveLfTagsFromResourceResponse = removeLfTagsFromResource(RemoveLfTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
 */
public suspend inline fun LakeFormationClient.revokePermissions(crossinline block: RevokePermissionsRequest.Builder.() -> Unit): RevokePermissionsResponse = revokePermissions(RevokePermissionsRequest.Builder().apply(block).build())

/**
 * This operation allows a search on `DATABASE` resources by `TagCondition`. This operation is used by admins who want to grant user permissions on certain `TagConditions`. Before making a grant, the admin can use `SearchDatabasesByTags` to find all resources where the given `TagConditions` are valid to verify whether the returned resources can be shared.
 */
public suspend inline fun LakeFormationClient.searchDatabasesByLfTags(crossinline block: SearchDatabasesByLfTagsRequest.Builder.() -> Unit): SearchDatabasesByLfTagsResponse = searchDatabasesByLfTags(SearchDatabasesByLfTagsRequest.Builder().apply(block).build())

/**
 * This operation allows a search on `TABLE` resources by `LFTag`s. This will be used by admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use `SearchTablesByLFTags` to find all resources where the given `LFTag`s are valid to verify whether the returned resources can be shared.
 */
public suspend inline fun LakeFormationClient.searchTablesByLfTags(crossinline block: SearchTablesByLfTagsRequest.Builder.() -> Unit): SearchTablesByLfTagsResponse = searchTablesByLfTags(SearchTablesByLfTagsRequest.Builder().apply(block).build())

/**
 * Submits a request to process a query statement.
 *
 * This operation generates work units that can be retrieved with the `GetWorkUnits` operation as soon as the query state is WORKUNITS_AVAILABLE or FINISHED.
 */
public suspend inline fun LakeFormationClient.startQueryPlanning(crossinline block: StartQueryPlanningRequest.Builder.() -> Unit): StartQueryPlanningResponse = startQueryPlanning(StartQueryPlanningRequest.Builder().apply(block).build())

/**
 * Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to identify a transaction.
 */
public suspend inline fun LakeFormationClient.startTransaction(crossinline block: StartTransactionRequest.Builder.() -> Unit): StartTransactionResponse = startTransaction(StartTransactionRequest.Builder().apply(block).build())

/**
 * Updates a data cell filter.
 */
public suspend inline fun LakeFormationClient.updateDataCellsFilter(crossinline block: UpdateDataCellsFilterRequest.Builder.() -> Unit): UpdateDataCellsFilterResponse = updateDataCellsFilter(UpdateDataCellsFilterRequest.Builder().apply(block).build())

/**
 * Updates the IAM Identity Center connection parameters.
 */
public suspend inline fun LakeFormationClient.updateLakeFormationIdentityCenterConfiguration(crossinline block: UpdateLakeFormationIdentityCenterConfigurationRequest.Builder.() -> Unit): UpdateLakeFormationIdentityCenterConfigurationResponse = updateLakeFormationIdentityCenterConfiguration(UpdateLakeFormationIdentityCenterConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.
 */
public suspend inline fun LakeFormationClient.updateLfTag(crossinline block: UpdateLfTagRequest.Builder.() -> Unit): UpdateLfTagResponse = updateLfTag(UpdateLfTagRequest.Builder().apply(block).build())

/**
 * Updates the name of the LF-Tag expression to the new description and expression body provided. Updating a LF-Tag expression immediately changes the permission boundaries of all existing `LFTagPolicy` permission grants that reference the given LF-Tag expression.
 */
public suspend inline fun LakeFormationClient.updateLfTagExpression(crossinline block: UpdateLfTagExpressionRequest.Builder.() -> Unit): UpdateLfTagExpressionResponse = updateLfTagExpression(UpdateLfTagExpressionRequest.Builder().apply(block).build())

/**
 * Updates the data access role used for vending access to the given (registered) resource in Lake Formation.
 */
public suspend inline fun LakeFormationClient.updateResource(crossinline block: UpdateResourceRequest.Builder.() -> Unit): UpdateResourceResponse = updateResource(UpdateResourceRequest.Builder().apply(block).build())

/**
 * Updates the manifest of Amazon S3 objects that make up the specified governed table.
 */
public suspend inline fun LakeFormationClient.updateTableObjects(crossinline block: UpdateTableObjectsRequest.Builder.() -> Unit): UpdateTableObjectsResponse = updateTableObjects(UpdateTableObjectsRequest.Builder().apply(block).build())

/**
 * Updates the configuration of the storage optimizers for a table.
 */
public suspend inline fun LakeFormationClient.updateTableStorageOptimizer(crossinline block: UpdateTableStorageOptimizerRequest.Builder.() -> Unit): UpdateTableStorageOptimizerResponse = updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest.Builder().apply(block).build())
