// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that defines an Amazon S3 object to be deleted if a transaction cancels, provided that `VirtualPut` was called before writing the object.
 */
public class VirtualObject private constructor(builder: Builder) {
    /**
     * The ETag of the Amazon S3 object.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * The path to the Amazon S3 object. Must start with s3://
     */
    public val uri: kotlin.String = requireNotNull(builder.uri) { "A non-null value must be provided for uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.VirtualObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VirtualObject(")
        append("eTag=$eTag,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag?.hashCode() ?: 0
        result = 31 * result + (uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VirtualObject

        if (eTag != other.eTag) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.VirtualObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ETag of the Amazon S3 object.
         */
        public var eTag: kotlin.String? = null
        /**
         * The path to the Amazon S3 object. Must start with s3://
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.VirtualObject) : this() {
            this.eTag = x.eTag
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.VirtualObject = VirtualObject(this)

        internal fun correctErrors(): Builder {
            if (uri == null) uri = ""
            return this
        }
    }
}
