// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure containing information about the query plan.
 */
public class QueryPlanningContext private constructor(builder: Builder) {
    /**
     * The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * The database containing the table.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `TransactionId`.
     */
    public val queryAsOfTime: aws.smithy.kotlin.runtime.time.Instant? = builder.queryAsOfTime
    /**
     * A map consisting of key-value pairs.
     */
    public val queryParameters: Map<String, String>? = builder.queryParameters
    /**
     * The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with `QueryAsOfTime`.
     */
    public val transactionId: kotlin.String? = builder.transactionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.QueryPlanningContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryPlanningContext(")
        append("catalogId=$catalogId,")
        append("databaseName=$databaseName,")
        append("queryAsOfTime=$queryAsOfTime,")
        append("queryParameters=$queryParameters,")
        append("transactionId=$transactionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (queryAsOfTime?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryPlanningContext

        if (catalogId != other.catalogId) return false
        if (databaseName != other.databaseName) return false
        if (queryAsOfTime != other.queryAsOfTime) return false
        if (queryParameters != other.queryParameters) return false
        if (transactionId != other.transactionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.QueryPlanningContext = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default.
         */
        public var catalogId: kotlin.String? = null
        /**
         * The database containing the table.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `TransactionId`.
         */
        public var queryAsOfTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A map consisting of key-value pairs.
         */
        public var queryParameters: Map<String, String>? = null
        /**
         * The transaction ID at which to read the table contents. If this transaction is not committed, the read will be treated as part of that transaction and will see its writes. If this transaction has aborted, an error will be returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with `QueryAsOfTime`.
         */
        public var transactionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.QueryPlanningContext) : this() {
            this.catalogId = x.catalogId
            this.databaseName = x.databaseName
            this.queryAsOfTime = x.queryAsOfTime
            this.queryParameters = x.queryParameters
            this.transactionId = x.transactionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.QueryPlanningContext = QueryPlanningContext(this)

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            return this
        }
    }
}
