// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GrantPermissionsRequest private constructor(builder: Builder) {
    /**
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     */
    public val condition: aws.sdk.kotlin.services.lakeformation.model.Condition? = builder.condition
    /**
     * The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources.
     */
    public val permissions: List<Permission>? = builder.permissions
    /**
     * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the `Privileges`.
     */
    public val permissionsWithGrantOption: List<Permission>? = builder.permissionsWithGrantOption
    /**
     * The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.
     *
     * Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted.
     */
    public val principal: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal? = builder.principal
    /**
     * The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.
     */
    public val resource: aws.sdk.kotlin.services.lakeformation.model.Resource? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GrantPermissionsRequest(")
        append("catalogId=$catalogId,")
        append("condition=$condition,")
        append("permissions=$permissions,")
        append("permissionsWithGrantOption=$permissionsWithGrantOption,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (permissionsWithGrantOption?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GrantPermissionsRequest

        if (catalogId != other.catalogId) return false
        if (condition != other.condition) return false
        if (permissions != other.permissions) return false
        if (permissionsWithGrantOption != other.permissionsWithGrantOption) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
         */
        public var catalogId: kotlin.String? = null
        /**
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         */
        public var condition: aws.sdk.kotlin.services.lakeformation.model.Condition? = null
        /**
         * The permissions granted to the principal on the resource. Lake Formation defines privileges to grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Lake Formation requires that each principal be authorized to perform a specific task on Lake Formation resources.
         */
        public var permissions: List<Permission>? = null
        /**
         * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may only be a subset of the permissions granted in the `Privileges`.
         */
        public var permissionsWithGrantOption: List<Permission>? = null
        /**
         * The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and they are defined by their principal type and their ARN.
         *
         * Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that same ARN, the resource maintains the permissions already granted.
         */
        public var principal: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal? = null
        /**
         * The resource to which permissions are to be granted. Resources in Lake Formation are the Data Catalog, databases, and tables.
         */
        public var resource: aws.sdk.kotlin.services.lakeformation.model.Resource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsRequest) : this() {
            this.catalogId = x.catalogId
            this.condition = x.condition
            this.permissions = x.permissions
            this.permissionsWithGrantOption = x.permissionsWithGrantOption
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.GrantPermissionsRequest = GrantPermissionsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.Condition] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.lakeformation.model.Condition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.lakeformation.model.Condition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal] inside the given [block]
         */
        public fun principal(block: aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal.Builder.() -> kotlin.Unit) {
            this.principal = aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.Resource] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.lakeformation.model.Resource.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.lakeformation.model.Resource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
