// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object to delete from the governed table.
 */
public class DeleteObjectInput private constructor(builder: Builder) {
    /**
     * The Amazon S3 ETag of the object. Returned by `GetTableObjects` for validation and used to identify changes to the underlying data.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * A list of partition values for the object. A value must be specified for each partition key associated with the governed table.
     */
    public val partitionValues: List<String>? = builder.partitionValues
    /**
     * The Amazon S3 location of the object to delete.
     */
    public val uri: kotlin.String = requireNotNull(builder.uri) { "A non-null value must be provided for uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.DeleteObjectInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteObjectInput(")
        append("eTag=$eTag,")
        append("partitionValues=$partitionValues,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag?.hashCode() ?: 0
        result = 31 * result + (partitionValues?.hashCode() ?: 0)
        result = 31 * result + (uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteObjectInput

        if (eTag != other.eTag) return false
        if (partitionValues != other.partitionValues) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.DeleteObjectInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 ETag of the object. Returned by `GetTableObjects` for validation and used to identify changes to the underlying data.
         */
        public var eTag: kotlin.String? = null
        /**
         * A list of partition values for the object. A value must be specified for each partition key associated with the governed table.
         */
        public var partitionValues: List<String>? = null
        /**
         * The Amazon S3 location of the object to delete.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.DeleteObjectInput) : this() {
            this.eTag = x.eTag
            this.partitionValues = x.partitionValues
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.DeleteObjectInput = DeleteObjectInput(this)

        internal fun correctErrors(): Builder {
            if (uri == null) uri = ""
            return this
        }
    }
}
