// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.Condition
import aws.sdk.kotlin.services.lakeformation.model.DataLakePrincipal
import aws.sdk.kotlin.services.lakeformation.model.Permission
import aws.sdk.kotlin.services.lakeformation.model.Resource
import aws.sdk.kotlin.services.lakeformation.model.RevokePermissionsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RevokePermissionsOperationSerializer: HttpSerializer.NonStreaming<RevokePermissionsRequest> {
    override fun serialize(context: ExecutionContext, input: RevokePermissionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/RevokePermissions"
        }

        val payload = serializeRevokePermissionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRevokePermissionsOperationBody(context: ExecutionContext, input: RevokePermissionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CATALOGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CatalogId"))
    val CONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Condition"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val PERMISSIONSWITHGRANTOPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PermissionsWithGrantOption"))
    val PRINCIPAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Principal"))
    val RESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Resource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CATALOGID_DESCRIPTOR)
        field(CONDITION_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(PERMISSIONSWITHGRANTOPTION_DESCRIPTOR)
        field(PRINCIPAL_DESCRIPTOR)
        field(RESOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.catalogId?.let { field(CATALOGID_DESCRIPTOR, it) }
        input.condition?.let { field(CONDITION_DESCRIPTOR, it, ::serializeConditionDocument) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.permissionsWithGrantOption != null) {
            listField(PERMISSIONSWITHGRANTOPTION_DESCRIPTOR) {
                for (el0 in input.permissionsWithGrantOption) {
                    serializeString(el0.value)
                }
            }
        }
        input.principal?.let { field(PRINCIPAL_DESCRIPTOR, it, ::serializeDataLakePrincipalDocument) }
        input.resource?.let { field(RESOURCE_DESCRIPTOR, it, ::serializeResourceDocument) }
    }
    return serializer.toByteArray()
}
