// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.serde

import aws.sdk.kotlin.services.lakeformation.model.ColumnLfTag
import aws.sdk.kotlin.services.lakeformation.model.GetResourceLfTagsResponse
import aws.sdk.kotlin.services.lakeformation.model.LakeFormationException
import aws.sdk.kotlin.services.lakeformation.model.LfTagPair
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetResourceLFTagsOperationDeserializer: HttpDeserializer.NonStreaming<GetResourceLfTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetResourceLfTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourceLfTagsError(context, call, payload)
        }
        val builder = GetResourceLfTagsResponse.Builder()

        if (payload != null) {
            deserializeGetResourceLFTagsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetResourceLfTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LakeFormationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EntityNotFoundException" -> EntityNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "GlueEncryptionException" -> GlueEncryptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationTimeoutException" -> OperationTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LakeFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceLFTagsOperationBody(builder: GetResourceLfTagsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LFTAGONDATABASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LFTagOnDatabase"))
    val LFTAGSONCOLUMNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LFTagsOnColumns"))
    val LFTAGSONTABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LFTagsOnTable"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LFTAGONDATABASE_DESCRIPTOR)
        field(LFTAGSONCOLUMNS_DESCRIPTOR)
        field(LFTAGSONTABLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LFTAGONDATABASE_DESCRIPTOR.index -> builder.lfTagOnDatabase =
                    deserializer.deserializeList(LFTAGONDATABASE_DESCRIPTOR) {
                        val col0 = mutableListOf<LfTagPair>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLfTagPairDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LFTAGSONCOLUMNS_DESCRIPTOR.index -> builder.lfTagsOnColumns =
                    deserializer.deserializeList(LFTAGSONCOLUMNS_DESCRIPTOR) {
                        val col0 = mutableListOf<ColumnLfTag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeColumnLfTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LFTAGSONTABLE_DESCRIPTOR.index -> builder.lfTagsOnTable =
                    deserializer.deserializeList(LFTAGSONTABLE_DESCRIPTOR) {
                        val col0 = mutableListOf<LfTagPair>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLfTagPairDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
