// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure for a table with columns object. This object is only used when granting a SELECT permission.
 *
 * This object must take a value for at least one of `ColumnsNames`, `ColumnsIndexes`, or `ColumnsWildcard`.
 */
public class TableWithColumnsResource private constructor(builder: Builder) {
    /**
     * The identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * The list of column names for the table. At least one of `ColumnNames` or `ColumnWildcard` is required.
     */
    public val columnNames: List<String>? = builder.columnNames
    /**
     * A wildcard specified by a `ColumnWildcard` object. At least one of `ColumnNames` or `ColumnWildcard` is required.
     */
    public val columnWildcard: aws.sdk.kotlin.services.lakeformation.model.ColumnWildcard? = builder.columnWildcard
    /**
     * The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.TableWithColumnsResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableWithColumnsResource(")
        append("catalogId=$catalogId,")
        append("columnNames=$columnNames,")
        append("columnWildcard=$columnWildcard,")
        append("databaseName=$databaseName,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (columnNames?.hashCode() ?: 0)
        result = 31 * result + (columnWildcard?.hashCode() ?: 0)
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableWithColumnsResource

        if (catalogId != other.catalogId) return false
        if (columnNames != other.columnNames) return false
        if (columnWildcard != other.columnWildcard) return false
        if (databaseName != other.databaseName) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.TableWithColumnsResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the Data Catalog. By default, it is the account ID of the caller.
         */
        public var catalogId: kotlin.String? = null
        /**
         * The list of column names for the table. At least one of `ColumnNames` or `ColumnWildcard` is required.
         */
        public var columnNames: List<String>? = null
        /**
         * A wildcard specified by a `ColumnWildcard` object. At least one of `ColumnNames` or `ColumnWildcard` is required.
         */
        public var columnWildcard: aws.sdk.kotlin.services.lakeformation.model.ColumnWildcard? = null
        /**
         * The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The name of the table resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.TableWithColumnsResource) : this() {
            this.catalogId = x.catalogId
            this.columnNames = x.columnNames
            this.columnWildcard = x.columnWildcard
            this.databaseName = x.databaseName
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.TableWithColumnsResource = TableWithColumnsResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.lakeformation.model.ColumnWildcard] inside the given [block]
         */
        public fun columnWildcard(block: aws.sdk.kotlin.services.lakeformation.model.ColumnWildcard.Builder.() -> kotlin.Unit) {
            this.columnWildcard = aws.sdk.kotlin.services.lakeformation.model.ColumnWildcard.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            if (name == null) name = ""
            return this
        }
    }
}
