// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterResourceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
     */
    public val hybridAccessEnabled: kotlin.Boolean? = builder.hybridAccessEnabled
    /**
     * The Amazon Resource Name (ARN) of the resource that you want to register.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The identifier for the role that registers the resource.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.
     *
     * For more information, see [Using Service-Linked Roles for Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html).
     */
    public val useServiceLinkedRole: kotlin.Boolean? = builder.useServiceLinkedRole
    /**
     * Whether or not the resource is a federated resource.
     */
    public val withFederation: kotlin.Boolean? = builder.withFederation
    /**
     * Grants the calling principal the permissions to perform all supported Lake Formation operations on the registered data location.
     */
    public val withPrivilegedAccess: kotlin.Boolean? = builder.withPrivilegedAccess

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.RegisterResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterResourceRequest(")
        append("hybridAccessEnabled=$hybridAccessEnabled,")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn,")
        append("useServiceLinkedRole=$useServiceLinkedRole,")
        append("withFederation=$withFederation,")
        append("withPrivilegedAccess=$withPrivilegedAccess")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hybridAccessEnabled?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (useServiceLinkedRole?.hashCode() ?: 0)
        result = 31 * result + (withFederation?.hashCode() ?: 0)
        result = 31 * result + (withPrivilegedAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterResourceRequest

        if (hybridAccessEnabled != other.hybridAccessEnabled) return false
        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false
        if (useServiceLinkedRole != other.useServiceLinkedRole) return false
        if (withFederation != other.withFederation) return false
        if (withPrivilegedAccess != other.withPrivilegedAccess) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.RegisterResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
         */
        public var hybridAccessEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the resource that you want to register.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The identifier for the role that registers the resource.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.
         *
         * For more information, see [Using Service-Linked Roles for Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html).
         */
        public var useServiceLinkedRole: kotlin.Boolean? = null
        /**
         * Whether or not the resource is a federated resource.
         */
        public var withFederation: kotlin.Boolean? = null
        /**
         * Grants the calling principal the permissions to perform all supported Lake Formation operations on the registered data location.
         */
        public var withPrivilegedAccess: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.RegisterResourceRequest) : this() {
            this.hybridAccessEnabled = x.hybridAccessEnabled
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
            this.useServiceLinkedRole = x.useServiceLinkedRole
            this.withFederation = x.withFederation
            this.withPrivilegedAccess = x.withPrivilegedAccess
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.RegisterResourceRequest = RegisterResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
