// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lakeformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A new object to add to the governed table.
 */
public class AddObjectInput private constructor(builder: Builder) {
    /**
     * The Amazon S3 ETag of the object. Returned by `GetTableObjects` for validation and used to identify changes to the underlying data.
     */
    public val eTag: kotlin.String = requireNotNull(builder.eTag) { "A non-null value must be provided for eTag" }
    /**
     * A list of partition values for the object. A value must be specified for each partition key associated with the table.
     *
     * The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
     */
    public val partitionValues: List<String>? = builder.partitionValues
    /**
     * The size of the Amazon S3 object in bytes.
     */
    public val size: kotlin.Long = builder.size
    /**
     * The Amazon S3 location of the object.
     */
    public val uri: kotlin.String = requireNotNull(builder.uri) { "A non-null value must be provided for uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lakeformation.model.AddObjectInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddObjectInput(")
        append("eTag=$eTag,")
        append("partitionValues=$partitionValues,")
        append("size=$size,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag.hashCode()
        result = 31 * result + (partitionValues?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddObjectInput

        if (eTag != other.eTag) return false
        if (partitionValues != other.partitionValues) return false
        if (size != other.size) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lakeformation.model.AddObjectInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 ETag of the object. Returned by `GetTableObjects` for validation and used to identify changes to the underlying data.
         */
        public var eTag: kotlin.String? = null
        /**
         * A list of partition values for the object. A value must be specified for each partition key associated with the table.
         *
         * The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
         */
        public var partitionValues: List<String>? = null
        /**
         * The size of the Amazon S3 object in bytes.
         */
        public var size: kotlin.Long = 0L
        /**
         * The Amazon S3 location of the object.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lakeformation.model.AddObjectInput) : this() {
            this.eTag = x.eTag
            this.partitionValues = x.partitionValues
            this.size = x.size
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lakeformation.model.AddObjectInput = AddObjectInput(this)

        internal fun correctErrors(): Builder {
            if (eTag == null) eTag = ""
            if (uri == null) uri = ""
            return this
        }
    }
}
