// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this structure to allow [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) in the grant only when the operation request includes the specified [encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
 *
 * KMS applies the grant constraints only to cryptographic operations that support an encryption context, that is, all cryptographic operations with a [symmetric KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#symmetric-cmks). Grant constraints are not applied to operations that do not support an encryption context, such as cryptographic operations with asymmetric KMS keys and management operations, such as DescribeKey or RetireGrant.
 *
 * In a cryptographic operation, the encryption context in the decryption operation must be an exact, case-sensitive match for the keys and values in the encryption context of the encryption operation. Only the order of the pairs can vary.
 *
 * However, in a grant constraint, the key in each key-value pair is not case sensitive, but the value is case sensitive.
 *
 * To avoid confusion, do not use multiple encryption context pairs that differ only by case. To require a fully case-sensitive encryption context, use the `kms:EncryptionContext:` and `kms:EncryptionContextKeys` conditions in an IAM or key policy. For details, see [kms:EncryptionContext:](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-context) in the **Key Management Service Developer Guide**.
 */
public class GrantConstraints private constructor(builder: Builder) {
    /**
     * A list of key-value pairs that must match the encryption context in the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.
     */
    public val encryptionContextEquals: Map<String, String>? = builder.encryptionContextEquals
    /**
     * A list of key-value pairs that must be included in the encryption context of the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.
     */
    public val encryptionContextSubset: Map<String, String>? = builder.encryptionContextSubset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GrantConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GrantConstraints(")
        append("encryptionContextEquals=$encryptionContextEquals,")
        append("encryptionContextSubset=$encryptionContextSubset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionContextEquals?.hashCode() ?: 0
        result = 31 * result + (encryptionContextSubset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GrantConstraints

        if (encryptionContextEquals != other.encryptionContextEquals) return false
        if (encryptionContextSubset != other.encryptionContextSubset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GrantConstraints = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of key-value pairs that must match the encryption context in the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint.
         */
        public var encryptionContextEquals: Map<String, String>? = null
        /**
         * A list of key-value pairs that must be included in the encryption context of the [cryptographic operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) request. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs.
         */
        public var encryptionContextSubset: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GrantConstraints) : this() {
            this.encryptionContextEquals = x.encryptionContextEquals
            this.encryptionContextSubset = x.encryptionContextSubset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GrantConstraints = GrantConstraints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
