// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeriveSharedSecretResponse private constructor(builder: Builder) {
    /**
     * The plaintext shared secret encrypted with the public key in the attestation document.
     *
     * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val ciphertextForRecipient: kotlin.ByteArray? = builder.ciphertextForRecipient
    /**
     * Identifies the key agreement algorithm used to derive the shared secret.
     */
    public val keyAgreementAlgorithm: aws.sdk.kotlin.services.kms.model.KeyAgreementAlgorithmSpec? = builder.keyAgreementAlgorithm
    /**
     * Identifies the KMS key used to derive the shared secret.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The source of the key material for the specified KMS key.
     *
     * When this value is `AWS_KMS`, KMS created the key material. When this value is `EXTERNAL`, the key material was imported or the KMS key doesn't have any key material.
     *
     * The only valid values for DeriveSharedSecret are `AWS_KMS` and `EXTERNAL`. DeriveSharedSecret does not support KMS keys with a `KeyOrigin` value of `AWS_CLOUDHSM` or `EXTERNAL_KEY_STORE`.
     */
    public val keyOrigin: aws.sdk.kotlin.services.kms.model.OriginType? = builder.keyOrigin
    /**
     * The raw secret derived from the specified key agreement algorithm, private key in the asymmetric KMS key, and your peer's public key.
     *
     * If the response includes the `CiphertextForRecipient` field, the `SharedSecret` field is null or empty.
     */
    public val sharedSecret: kotlin.ByteArray? = builder.sharedSecret

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.DeriveSharedSecretResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeriveSharedSecretResponse(")
        append("ciphertextForRecipient=$ciphertextForRecipient,")
        append("keyAgreementAlgorithm=$keyAgreementAlgorithm,")
        append("keyId=$keyId,")
        append("keyOrigin=$keyOrigin,")
        append("sharedSecret=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextForRecipient?.contentHashCode() ?: 0
        result = 31 * result + (keyAgreementAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyOrigin?.hashCode() ?: 0)
        result = 31 * result + (sharedSecret?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeriveSharedSecretResponse

        if (ciphertextForRecipient != null) {
            if (other.ciphertextForRecipient == null) return false
            if (!ciphertextForRecipient.contentEquals(other.ciphertextForRecipient)) return false
        } else if (other.ciphertextForRecipient != null) return false
        if (keyAgreementAlgorithm != other.keyAgreementAlgorithm) return false
        if (keyId != other.keyId) return false
        if (keyOrigin != other.keyOrigin) return false
        if (sharedSecret != null) {
            if (other.sharedSecret == null) return false
            if (!sharedSecret.contentEquals(other.sharedSecret)) return false
        } else if (other.sharedSecret != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.DeriveSharedSecretResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The plaintext shared secret encrypted with the public key in the attestation document.
         *
         * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var ciphertextForRecipient: kotlin.ByteArray? = null
        /**
         * Identifies the key agreement algorithm used to derive the shared secret.
         */
        public var keyAgreementAlgorithm: aws.sdk.kotlin.services.kms.model.KeyAgreementAlgorithmSpec? = null
        /**
         * Identifies the KMS key used to derive the shared secret.
         */
        public var keyId: kotlin.String? = null
        /**
         * The source of the key material for the specified KMS key.
         *
         * When this value is `AWS_KMS`, KMS created the key material. When this value is `EXTERNAL`, the key material was imported or the KMS key doesn't have any key material.
         *
         * The only valid values for DeriveSharedSecret are `AWS_KMS` and `EXTERNAL`. DeriveSharedSecret does not support KMS keys with a `KeyOrigin` value of `AWS_CLOUDHSM` or `EXTERNAL_KEY_STORE`.
         */
        public var keyOrigin: aws.sdk.kotlin.services.kms.model.OriginType? = null
        /**
         * The raw secret derived from the specified key agreement algorithm, private key in the asymmetric KMS key, and your peer's public key.
         *
         * If the response includes the `CiphertextForRecipient` field, the `SharedSecret` field is null or empty.
         */
        public var sharedSecret: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.DeriveSharedSecretResponse) : this() {
            this.ciphertextForRecipient = x.ciphertextForRecipient
            this.keyAgreementAlgorithm = x.keyAgreementAlgorithm
            this.keyId = x.keyId
            this.keyOrigin = x.keyOrigin
            this.sharedSecret = x.sharedSecret
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.DeriveSharedSecretResponse = DeriveSharedSecretResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
