// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.
 *
 * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
 *
 * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *Amazon Web Services Billing and Cost Management User Guide*.
 */
public class Tag private constructor(builder: Builder) {
    /**
     * The key of the tag.
     */
    public val tagKey: kotlin.String = requireNotNull(builder.tagKey) { "A non-null value must be provided for tagKey" }
    /**
     * The value of the tag.
     */
    public val tagValue: kotlin.String = requireNotNull(builder.tagValue) { "A non-null value must be provided for tagValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("tagKey=$tagKey,")
        append("tagValue=$tagValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tagKey.hashCode()
        result = 31 * result + (tagValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (tagKey != other.tagKey) return false
        if (tagValue != other.tagValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.Tag = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key of the tag.
         */
        public var tagKey: kotlin.String? = null
        /**
         * The value of the tag.
         */
        public var tagValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.Tag) : this() {
            this.tagKey = x.tagKey
            this.tagValue = x.tagValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.Tag = Tag(this)

        internal fun correctErrors(): Builder {
            if (tagKey == null) tagKey = ""
            if (tagValue == null) tagValue = ""
            return this
        }
    }
}
