// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCustomKeyStoreRequest private constructor(builder: Builder) {
    /**
     * Identifies the CloudHSM cluster for an CloudHSM key store. This parameter is required for custom key stores with `CustomKeyStoreType` of `AWS_CLOUDHSM`.
     *
     * Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account and Region. This parameter is required for all custom key stores.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     */
    public val customKeyStoreName: kotlin.String? = builder.customKeyStoreName
    /**
     * Specifies the type of custom key store. The default value is `AWS_CLOUDHSM`.
     *
     * For a custom key store backed by an CloudHSM cluster, omit the parameter or enter `AWS_CLOUDHSM`. For a custom key store backed by an external key manager outside of Amazon Web Services, enter `EXTERNAL_KEY_STORE`. You cannot change this property after the key store is created.
     */
    public val customKeyStoreType: aws.sdk.kotlin.services.kms.model.CustomKeyStoreType? = builder.customKeyStoreType
    /**
     * Specifies the `kmsuser` password for an CloudHSM key store. This parameter is required for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
     *
     * Enter the password of the `kmsuser`[ crypto user (CU) account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser) in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.
     *
     * The password must be a string of 7 to 32 characters. Its value is case sensitive.
     *
     * This parameter tells KMS the `kmsuser` account password; it does not change the password in the CloudHSM cluster.
     */
    public val keyStorePassword: kotlin.String? = builder.keyStorePassword
    /**
     * Specifies the certificate for an CloudHSM key store. This parameter is required for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
     *
     * Enter the content of the trust anchor certificate for the CloudHSM cluster. This is the content of the `customerCA.crt` file that you created when you [initialized the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
     */
    public val trustAnchorCertificate: kotlin.String? = builder.trustAnchorCertificate
    /**
     * Specifies an authentication credential for the external key store proxy (XKS proxy). This parameter is required for all custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * The `XksProxyAuthenticationCredential` has two required elements: `RawSecretAccessKey`, a secret key, and `AccessKeyId`, a unique identifier for the `RawSecretAccessKey`. For character requirements, see [XksProxyAuthenticationCredentialType](kms/latest/APIReference/API_XksProxyAuthenticationCredentialType.html).
     *
     * KMS uses this authentication credential to sign requests to the external key store proxy on your behalf. This credential is unrelated to Identity and Access Management (IAM) and Amazon Web Services credentials.
     *
     * This parameter doesn't set or change the authentication credentials on the XKS proxy. It just tells KMS the credential that you established on your external key store proxy. If you rotate your proxy authentication credential, use the UpdateCustomKeyStore operation to provide the new credential to KMS.
     */
    public val xksProxyAuthenticationCredential: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType? = builder.xksProxyAuthenticationCredential
    /**
     * Indicates how KMS communicates with the external key store proxy. This parameter is required for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * If the external key store proxy uses a public endpoint, specify `PUBLIC_ENDPOINT`. If the external key store proxy uses a Amazon VPC endpoint service for communication with KMS, specify `VPC_ENDPOINT_SERVICE`. For help making this choice, see [Choosing a connectivity option](https://docs.aws.amazon.com/kms/latest/developerguide/plan-xks-keystore.html#choose-xks-connectivity) in the *Key Management Service Developer Guide*.
     *
     * An Amazon VPC endpoint service keeps your communication with KMS in a private address space entirely within Amazon Web Services, but it requires more configuration, including establishing a Amazon VPC with multiple subnets, a VPC endpoint service, a network load balancer, and a verified private DNS name. A public endpoint is simpler to set up, but it might be slower and might not fulfill your security requirements. You might consider testing with a public endpoint, and then establishing a VPC endpoint service for production tasks. Note that this choice does not determine the location of the external key store proxy. Even if you choose a VPC endpoint service, the proxy can be hosted within the VPC or outside of Amazon Web Services such as in your corporate data center.
     */
    public val xksProxyConnectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = builder.xksProxyConnectivity
    /**
     * Specifies the endpoint that KMS uses to send requests to the external key store proxy (XKS proxy). This parameter is required for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * The protocol must be HTTPS. KMS communicates on port 443. Do not specify the port in the `XksProxyUriEndpoint` value.
     *
     * For external key stores with `XksProxyConnectivity` value of `VPC_ENDPOINT_SERVICE`, specify `https://` followed by the private DNS name of the VPC endpoint service.
     *
     * For external key stores with `PUBLIC_ENDPOINT` connectivity, this endpoint must be reachable before you create the custom key store. KMS connects to the external key store proxy while creating the custom key store. For external key stores with `VPC_ENDPOINT_SERVICE` connectivity, KMS connects when you call the ConnectCustomKeyStore operation.
     *
     * The value of this parameter must begin with `https://`. The remainder can contain upper and lower case letters (A-Z and a-z), numbers (0-9), dots (`.`), and hyphens (`-`). Additional slashes (`/` and `\`) are not permitted.
     *
     * **Uniqueness requirements: **
     * + The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
     * + An external key store with `PUBLIC_ENDPOINT` connectivity cannot use the same `XksProxyUriEndpoint` value as an external key store with `VPC_ENDPOINT_SERVICE` connectivity in this Amazon Web Services Region.
     * + Each external key store with `VPC_ENDPOINT_SERVICE` connectivity must have its own private DNS name. The `XksProxyUriEndpoint` value for external key stores with `VPC_ENDPOINT_SERVICE` connectivity (private DNS name) must be unique in the Amazon Web Services account and Region.
     */
    public val xksProxyUriEndpoint: kotlin.String? = builder.xksProxyUriEndpoint
    /**
     * Specifies the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key store proxy. This parameter is required for all custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * The value must start with `/` and must end with `/kms/xks/v1` where `v1` represents the version of the KMS external key store proxy API. This path can include an optional prefix between the required elements such as `/<i>prefix</i>/kms/xks/v1`.
     *
     * **Uniqueness requirements: **
     * + The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
     */
    public val xksProxyUriPath: kotlin.String? = builder.xksProxyUriPath
    /**
     * Specifies the name of the Amazon VPC endpoint service for interface endpoints that is used to communicate with your external key store proxy (XKS proxy). This parameter is required when the value of `CustomKeyStoreType` is `EXTERNAL_KEY_STORE` and the value of `XksProxyConnectivity` is `VPC_ENDPOINT_SERVICE`.
     *
     * The Amazon VPC endpoint service must [fulfill all requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements) for use with an external key store.
     *
     * **Uniqueness requirements:**
     * + External key stores with `VPC_ENDPOINT_SERVICE` connectivity can share an Amazon VPC, but each external key store must have its own VPC endpoint service and private DNS name.
     */
    public val xksProxyVpcEndpointServiceName: kotlin.String? = builder.xksProxyVpcEndpointServiceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomKeyStoreRequest(")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("customKeyStoreName=$customKeyStoreName,")
        append("customKeyStoreType=$customKeyStoreType,")
        append("keyStorePassword=*** Sensitive Data Redacted ***,")
        append("trustAnchorCertificate=$trustAnchorCertificate,")
        append("xksProxyAuthenticationCredential=$xksProxyAuthenticationCredential,")
        append("xksProxyConnectivity=$xksProxyConnectivity,")
        append("xksProxyUriEndpoint=$xksProxyUriEndpoint,")
        append("xksProxyUriPath=$xksProxyUriPath,")
        append("xksProxyVpcEndpointServiceName=$xksProxyVpcEndpointServiceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudHsmClusterId?.hashCode() ?: 0
        result = 31 * result + (customKeyStoreName?.hashCode() ?: 0)
        result = 31 * result + (customKeyStoreType?.hashCode() ?: 0)
        result = 31 * result + (keyStorePassword?.hashCode() ?: 0)
        result = 31 * result + (trustAnchorCertificate?.hashCode() ?: 0)
        result = 31 * result + (xksProxyAuthenticationCredential?.hashCode() ?: 0)
        result = 31 * result + (xksProxyConnectivity?.hashCode() ?: 0)
        result = 31 * result + (xksProxyUriEndpoint?.hashCode() ?: 0)
        result = 31 * result + (xksProxyUriPath?.hashCode() ?: 0)
        result = 31 * result + (xksProxyVpcEndpointServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomKeyStoreRequest

        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (customKeyStoreName != other.customKeyStoreName) return false
        if (customKeyStoreType != other.customKeyStoreType) return false
        if (keyStorePassword != other.keyStorePassword) return false
        if (trustAnchorCertificate != other.trustAnchorCertificate) return false
        if (xksProxyAuthenticationCredential != other.xksProxyAuthenticationCredential) return false
        if (xksProxyConnectivity != other.xksProxyConnectivity) return false
        if (xksProxyUriEndpoint != other.xksProxyUriEndpoint) return false
        if (xksProxyUriPath != other.xksProxyUriPath) return false
        if (xksProxyVpcEndpointServiceName != other.xksProxyVpcEndpointServiceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifies the CloudHSM cluster for an CloudHSM key store. This parameter is required for custom key stores with `CustomKeyStoreType` of `AWS_CLOUDHSM`.
         *
         * Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account and Region. This parameter is required for all custom key stores.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         */
        public var customKeyStoreName: kotlin.String? = null
        /**
         * Specifies the type of custom key store. The default value is `AWS_CLOUDHSM`.
         *
         * For a custom key store backed by an CloudHSM cluster, omit the parameter or enter `AWS_CLOUDHSM`. For a custom key store backed by an external key manager outside of Amazon Web Services, enter `EXTERNAL_KEY_STORE`. You cannot change this property after the key store is created.
         */
        public var customKeyStoreType: aws.sdk.kotlin.services.kms.model.CustomKeyStoreType? = null
        /**
         * Specifies the `kmsuser` password for an CloudHSM key store. This parameter is required for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
         *
         * Enter the password of the `kmsuser`[ crypto user (CU) account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser) in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.
         *
         * The password must be a string of 7 to 32 characters. Its value is case sensitive.
         *
         * This parameter tells KMS the `kmsuser` account password; it does not change the password in the CloudHSM cluster.
         */
        public var keyStorePassword: kotlin.String? = null
        /**
         * Specifies the certificate for an CloudHSM key store. This parameter is required for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
         *
         * Enter the content of the trust anchor certificate for the CloudHSM cluster. This is the content of the `customerCA.crt` file that you created when you [initialized the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
         */
        public var trustAnchorCertificate: kotlin.String? = null
        /**
         * Specifies an authentication credential for the external key store proxy (XKS proxy). This parameter is required for all custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * The `XksProxyAuthenticationCredential` has two required elements: `RawSecretAccessKey`, a secret key, and `AccessKeyId`, a unique identifier for the `RawSecretAccessKey`. For character requirements, see [XksProxyAuthenticationCredentialType](kms/latest/APIReference/API_XksProxyAuthenticationCredentialType.html).
         *
         * KMS uses this authentication credential to sign requests to the external key store proxy on your behalf. This credential is unrelated to Identity and Access Management (IAM) and Amazon Web Services credentials.
         *
         * This parameter doesn't set or change the authentication credentials on the XKS proxy. It just tells KMS the credential that you established on your external key store proxy. If you rotate your proxy authentication credential, use the UpdateCustomKeyStore operation to provide the new credential to KMS.
         */
        public var xksProxyAuthenticationCredential: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType? = null
        /**
         * Indicates how KMS communicates with the external key store proxy. This parameter is required for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * If the external key store proxy uses a public endpoint, specify `PUBLIC_ENDPOINT`. If the external key store proxy uses a Amazon VPC endpoint service for communication with KMS, specify `VPC_ENDPOINT_SERVICE`. For help making this choice, see [Choosing a connectivity option](https://docs.aws.amazon.com/kms/latest/developerguide/plan-xks-keystore.html#choose-xks-connectivity) in the *Key Management Service Developer Guide*.
         *
         * An Amazon VPC endpoint service keeps your communication with KMS in a private address space entirely within Amazon Web Services, but it requires more configuration, including establishing a Amazon VPC with multiple subnets, a VPC endpoint service, a network load balancer, and a verified private DNS name. A public endpoint is simpler to set up, but it might be slower and might not fulfill your security requirements. You might consider testing with a public endpoint, and then establishing a VPC endpoint service for production tasks. Note that this choice does not determine the location of the external key store proxy. Even if you choose a VPC endpoint service, the proxy can be hosted within the VPC or outside of Amazon Web Services such as in your corporate data center.
         */
        public var xksProxyConnectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = null
        /**
         * Specifies the endpoint that KMS uses to send requests to the external key store proxy (XKS proxy). This parameter is required for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * The protocol must be HTTPS. KMS communicates on port 443. Do not specify the port in the `XksProxyUriEndpoint` value.
         *
         * For external key stores with `XksProxyConnectivity` value of `VPC_ENDPOINT_SERVICE`, specify `https://` followed by the private DNS name of the VPC endpoint service.
         *
         * For external key stores with `PUBLIC_ENDPOINT` connectivity, this endpoint must be reachable before you create the custom key store. KMS connects to the external key store proxy while creating the custom key store. For external key stores with `VPC_ENDPOINT_SERVICE` connectivity, KMS connects when you call the ConnectCustomKeyStore operation.
         *
         * The value of this parameter must begin with `https://`. The remainder can contain upper and lower case letters (A-Z and a-z), numbers (0-9), dots (`.`), and hyphens (`-`). Additional slashes (`/` and `\`) are not permitted.
         *
         * **Uniqueness requirements: **
         * + The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
         * + An external key store with `PUBLIC_ENDPOINT` connectivity cannot use the same `XksProxyUriEndpoint` value as an external key store with `VPC_ENDPOINT_SERVICE` connectivity in this Amazon Web Services Region.
         * + Each external key store with `VPC_ENDPOINT_SERVICE` connectivity must have its own private DNS name. The `XksProxyUriEndpoint` value for external key stores with `VPC_ENDPOINT_SERVICE` connectivity (private DNS name) must be unique in the Amazon Web Services account and Region.
         */
        public var xksProxyUriEndpoint: kotlin.String? = null
        /**
         * Specifies the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key store proxy. This parameter is required for all custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * The value must start with `/` and must end with `/kms/xks/v1` where `v1` represents the version of the KMS external key store proxy API. This path can include an optional prefix between the required elements such as `/<i>prefix</i>/kms/xks/v1`.
         *
         * **Uniqueness requirements: **
         * + The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
         */
        public var xksProxyUriPath: kotlin.String? = null
        /**
         * Specifies the name of the Amazon VPC endpoint service for interface endpoints that is used to communicate with your external key store proxy (XKS proxy). This parameter is required when the value of `CustomKeyStoreType` is `EXTERNAL_KEY_STORE` and the value of `XksProxyConnectivity` is `VPC_ENDPOINT_SERVICE`.
         *
         * The Amazon VPC endpoint service must [fulfill all requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements) for use with an external key store.
         *
         * **Uniqueness requirements:**
         * + External key stores with `VPC_ENDPOINT_SERVICE` connectivity can share an Amazon VPC, but each external key store must have its own VPC endpoint service and private DNS name.
         */
        public var xksProxyVpcEndpointServiceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest) : this() {
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.customKeyStoreName = x.customKeyStoreName
            this.customKeyStoreType = x.customKeyStoreType
            this.keyStorePassword = x.keyStorePassword
            this.trustAnchorCertificate = x.trustAnchorCertificate
            this.xksProxyAuthenticationCredential = x.xksProxyAuthenticationCredential
            this.xksProxyConnectivity = x.xksProxyConnectivity
            this.xksProxyUriEndpoint = x.xksProxyUriEndpoint
            this.xksProxyUriPath = x.xksProxyUriPath
            this.xksProxyVpcEndpointServiceName = x.xksProxyVpcEndpointServiceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = CreateCustomKeyStoreRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType] inside the given [block]
         */
        public fun xksProxyAuthenticationCredential(block: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType.Builder.() -> kotlin.Unit) {
            this.xksProxyAuthenticationCredential = aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
