// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.DataKeySpec
import aws.sdk.kotlin.services.kms.model.GenerateDataKeyRequest
import aws.sdk.kotlin.services.kms.model.RecipientInfo
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GenerateDataKeyOperationSerializer: HttpSerializer.NonStreaming<GenerateDataKeyRequest> {
    override fun serialize(context: ExecutionContext, input: GenerateDataKeyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeGenerateDataKeyOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeGenerateDataKeyOperationBody(context: ExecutionContext, input: GenerateDataKeyRequest): ByteArray {
    val serializer = JsonSerializer()
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val ENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("EncryptionContext"))
    val GRANTTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GrantTokens"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val KEYSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeySpec"))
    val NUMBEROFBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("NumberOfBytes"))
    val RECIPIENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Recipient"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DRYRUN_DESCRIPTOR)
        field(ENCRYPTIONCONTEXT_DESCRIPTOR)
        field(GRANTTOKENS_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(KEYSPEC_DESCRIPTOR)
        field(NUMBEROFBYTES_DESCRIPTOR)
        field(RECIPIENT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        if (input.encryptionContext != null) {
            mapField(ENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.encryptionContext.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        if (input.grantTokens != null) {
            listField(GRANTTOKENS_DESCRIPTOR) {
                for (el0 in input.grantTokens) {
                    serializeString(el0)
                }
            }
        }
        input.keyId?.let { field(KEYID_DESCRIPTOR, it) }
        input.keySpec?.let { field(KEYSPEC_DESCRIPTOR, it.value) }
        input.numberOfBytes?.let { field(NUMBEROFBYTES_DESCRIPTOR, it) }
        input.recipient?.let { field(RECIPIENT_DESCRIPTOR, it, ::serializeRecipientInfoDocument) }
    }
    return serializer.toByteArray()
}
