// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetKeyRotationStatusResponse private constructor(builder: Builder) {
    /**
     * Identifies the specified symmetric encryption KMS key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * A Boolean value that specifies whether key rotation is enabled.
     */
    public val keyRotationEnabled: kotlin.Boolean = builder.keyRotationEnabled
    /**
     * The next date that KMS will automatically rotate the key material.
     */
    public val nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.nextRotationDate
    /**
     * Identifies the date and time that an in progress on-demand rotation was initiated.
     *
     * The KMS API follows an [eventual consistency](https://docs.aws.amazon.com/kms/latest/developerguide/programming-eventual-consistency.html) model due to the distributed nature of the system. As a result, there might be a slight delay between initiating on-demand key rotation and the rotation's completion. Once the on-demand rotation is complete, use ListKeyRotations to view the details of the on-demand rotation.
     */
    public val onDemandRotationStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.onDemandRotationStartDate
    /**
     * The number of days between each automatic rotation. The default value is 365 days.
     */
    public val rotationPeriodInDays: kotlin.Int? = builder.rotationPeriodInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GetKeyRotationStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetKeyRotationStatusResponse(")
        append("keyId=$keyId,")
        append("keyRotationEnabled=$keyRotationEnabled,")
        append("nextRotationDate=$nextRotationDate,")
        append("onDemandRotationStartDate=$onDemandRotationStartDate,")
        append("rotationPeriodInDays=$rotationPeriodInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (keyRotationEnabled.hashCode())
        result = 31 * result + (nextRotationDate?.hashCode() ?: 0)
        result = 31 * result + (onDemandRotationStartDate?.hashCode() ?: 0)
        result = 31 * result + (rotationPeriodInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetKeyRotationStatusResponse

        if (keyId != other.keyId) return false
        if (keyRotationEnabled != other.keyRotationEnabled) return false
        if (nextRotationDate != other.nextRotationDate) return false
        if (onDemandRotationStartDate != other.onDemandRotationStartDate) return false
        if (rotationPeriodInDays != other.rotationPeriodInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GetKeyRotationStatusResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifies the specified symmetric encryption KMS key.
         */
        public var keyId: kotlin.String? = null
        /**
         * A Boolean value that specifies whether key rotation is enabled.
         */
        public var keyRotationEnabled: kotlin.Boolean = false
        /**
         * The next date that KMS will automatically rotate the key material.
         */
        public var nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Identifies the date and time that an in progress on-demand rotation was initiated.
         *
         * The KMS API follows an [eventual consistency](https://docs.aws.amazon.com/kms/latest/developerguide/programming-eventual-consistency.html) model due to the distributed nature of the system. As a result, there might be a slight delay between initiating on-demand key rotation and the rotation's completion. Once the on-demand rotation is complete, use ListKeyRotations to view the details of the on-demand rotation.
         */
        public var onDemandRotationStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days between each automatic rotation. The default value is 365 days.
         */
        public var rotationPeriodInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GetKeyRotationStatusResponse) : this() {
            this.keyId = x.keyId
            this.keyRotationEnabled = x.keyRotationEnabled
            this.nextRotationDate = x.nextRotationDate
            this.onDemandRotationStartDate = x.onDemandRotationStartDate
            this.rotationPeriodInDays = x.rotationPeriodInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GetKeyRotationStatusResponse = GetKeyRotationStatusResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
