// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class EnableKeyRotationRequest private constructor(builder: Builder) {
    /**
     * Identifies a symmetric encryption KMS key. You cannot enable automatic rotation of [asymmetric KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html), [HMAC KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html), KMS keys with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html), or KMS keys in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html). To enable or disable automatic rotation of a set of related [multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate), set the property on the primary key.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Use this parameter to specify a custom period of time between each rotation date. If no value is specified, the default value is 365 days.
     *
     * The rotation period defines the number of days after you enable automatic key rotation that KMS will rotate your key material, and the number of days between each automatic rotation thereafter.
     *
     * You can use the `kms:RotationPeriodInDays`[](https://docs.aws.amazon.com/kms/latest/developerguide/conditions-kms.html#conditions-kms-rotation-period-in-days) condition key to further constrain the values that principals can specify in the `RotationPeriodInDays` parameter.
     */
    public val rotationPeriodInDays: kotlin.Int? = builder.rotationPeriodInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.EnableKeyRotationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnableKeyRotationRequest(")
        append("keyId=$keyId,")
        append("rotationPeriodInDays=$rotationPeriodInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (rotationPeriodInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnableKeyRotationRequest

        if (keyId != other.keyId) return false
        if (rotationPeriodInDays != other.rotationPeriodInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.EnableKeyRotationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifies a symmetric encryption KMS key. You cannot enable automatic rotation of [asymmetric KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html), [HMAC KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html), KMS keys with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html), or KMS keys in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html). To enable or disable automatic rotation of a set of related [multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate), set the property on the primary key.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * Use this parameter to specify a custom period of time between each rotation date. If no value is specified, the default value is 365 days.
         *
         * The rotation period defines the number of days after you enable automatic key rotation that KMS will rotate your key material, and the number of days between each automatic rotation thereafter.
         *
         * You can use the `kms:RotationPeriodInDays`[](https://docs.aws.amazon.com/kms/latest/developerguide/conditions-kms.html#conditions-kms-rotation-period-in-days) condition key to further constrain the values that principals can specify in the `RotationPeriodInDays` parameter.
         */
        public var rotationPeriodInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.EnableKeyRotationRequest) : this() {
            this.keyId = x.keyId
            this.rotationPeriodInDays = x.rotationPeriodInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.EnableKeyRotationRequest = EnableKeyRotationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
