// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DecryptRequest private constructor(builder: Builder) {
    /**
     * Ciphertext to be decrypted. The blob includes metadata.
     */
    public val ciphertextBlob: kotlin.ByteArray? = builder.ciphertextBlob
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the `Decrypt` operation fails.
     *
     * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, `SYMMETRIC_DEFAULT`, represents the only supported algorithm that is valid for symmetric encryption KMS keys.
     */
    public val encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.encryptionAlgorithm
    /**
     * Specifies the encryption context to use when decrypting the data. An encryption context is valid only for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) with a symmetric encryption KMS key. The standard asymmetric encryption algorithms and HMAC algorithms that KMS uses do not support an encryption context.
     *
     * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
     *
     * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
     */
    public val encryptionContext: Map<String, String>? = builder.encryptionContext
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Specifies the KMS key that KMS uses to decrypt the ciphertext.
     *
     * Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the `Decrypt` operation throws an `IncorrectKeyException`.
     *
     * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * A signed [attestation document](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-concepts.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
     *
     * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
     *
     * When you use this parameter, instead of returning the plaintext data, KMS encrypts the plaintext data with the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `Plaintext` field in the response is null or empty.
     *
     * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = builder.recipient

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.DecryptRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DecryptRequest(")
        append("ciphertextBlob=$ciphertextBlob,")
        append("dryRun=$dryRun,")
        append("encryptionAlgorithm=$encryptionAlgorithm,")
        append("encryptionContext=$encryptionContext,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("recipient=$recipient")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextBlob?.contentHashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (encryptionContext?.hashCode() ?: 0)
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (recipient?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DecryptRequest

        if (ciphertextBlob != null) {
            if (other.ciphertextBlob == null) return false
            if (!ciphertextBlob.contentEquals(other.ciphertextBlob)) return false
        } else if (other.ciphertextBlob != null) return false
        if (dryRun != other.dryRun) return false
        if (encryptionAlgorithm != other.encryptionAlgorithm) return false
        if (encryptionContext != other.encryptionContext) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (recipient != other.recipient) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.DecryptRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Ciphertext to be decrypted. The blob includes metadata.
         */
        public var ciphertextBlob: kotlin.ByteArray? = null
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the `Decrypt` operation fails.
         *
         * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, `SYMMETRIC_DEFAULT`, represents the only supported algorithm that is valid for symmetric encryption KMS keys.
         */
        public var encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * Specifies the encryption context to use when decrypting the data. An encryption context is valid only for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) with a symmetric encryption KMS key. The standard asymmetric encryption algorithms and HMAC algorithms that KMS uses do not support an encryption context.
         *
         * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
         *
         * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
         */
        public var encryptionContext: Map<String, String>? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Specifies the KMS key that KMS uses to decrypt the ciphertext.
         *
         * Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the `Decrypt` operation throws an `IncorrectKeyException`.
         *
         * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * A signed [attestation document](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-concepts.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
         *
         * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
         *
         * When you use this parameter, instead of returning the plaintext data, KMS encrypts the plaintext data with the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `Plaintext` field in the response is null or empty.
         *
         * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.DecryptRequest) : this() {
            this.ciphertextBlob = x.ciphertextBlob
            this.dryRun = x.dryRun
            this.encryptionAlgorithm = x.encryptionAlgorithm
            this.encryptionContext = x.encryptionContext
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.recipient = x.recipient
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.DecryptRequest = DecryptRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.RecipientInfo] inside the given [block]
         */
        public fun recipient(block: aws.sdk.kotlin.services.kms.model.RecipientInfo.Builder.() -> kotlin.Unit) {
            this.recipient = aws.sdk.kotlin.services.kms.model.RecipientInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
