// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.DeriveSharedSecretResponse
import aws.sdk.kotlin.services.kms.model.KeyAgreementAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.OriginType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeriveSharedSecretOperationDeserializer: HttpDeserializer.NonStreaming<DeriveSharedSecretResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeriveSharedSecretResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeriveSharedSecretError(context, call, payload)
        }
        val builder = DeriveSharedSecretResponse.Builder()

        if (payload != null) {
            deserializeDeriveSharedSecretOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeriveSharedSecretError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeriveSharedSecretOperationBody(builder: DeriveSharedSecretResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CIPHERTEXTFORRECIPIENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("CiphertextForRecipient"))
    val KEYAGREEMENTALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeyAgreementAlgorithm"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val KEYORIGIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeyOrigin"))
    val SHAREDSECRET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("SharedSecret"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIPHERTEXTFORRECIPIENT_DESCRIPTOR)
        field(KEYAGREEMENTALGORITHM_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(KEYORIGIN_DESCRIPTOR)
        field(SHAREDSECRET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CIPHERTEXTFORRECIPIENT_DESCRIPTOR.index -> builder.ciphertextForRecipient = deserializeByteArray()
                KEYAGREEMENTALGORITHM_DESCRIPTOR.index -> builder.keyAgreementAlgorithm = deserializeString().let { KeyAgreementAlgorithmSpec.fromValue(it) }
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                KEYORIGIN_DESCRIPTOR.index -> builder.keyOrigin = deserializeString().let { OriginType.fromValue(it) }
                SHAREDSECRET_DESCRIPTOR.index -> builder.sharedSecret = deserializeByteArray()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
