// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ScheduleKeyDeletionResponse private constructor(builder: Builder) {
    /**
     * The date and time after which KMS deletes the KMS key.
     *
     * If the KMS key is a multi-Region primary key with replica keys, this field does not appear. The deletion date for the primary key isn't known until its last replica key is deleted.
     */
    public val deletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionDate
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key whose deletion is scheduled.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The current status of the KMS key.
     *
     * For more information about how key state affects the use of a KMS key, see [Key states of KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html) in the *Key Management Service Developer Guide*.
     */
    public val keyState: aws.sdk.kotlin.services.kms.model.KeyState? = builder.keyState
    /**
     * The waiting period before the KMS key is deleted.
     *
     * If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
     */
    public val pendingWindowInDays: kotlin.Int? = builder.pendingWindowInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleKeyDeletionResponse(")
        append("deletionDate=$deletionDate,")
        append("keyId=$keyId,")
        append("keyState=$keyState,")
        append("pendingWindowInDays=$pendingWindowInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionDate?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyState?.hashCode() ?: 0)
        result = 31 * result + (pendingWindowInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleKeyDeletionResponse

        if (deletionDate != other.deletionDate) return false
        if (keyId != other.keyId) return false
        if (keyState != other.keyState) return false
        if (pendingWindowInDays != other.pendingWindowInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time after which KMS deletes the KMS key.
         *
         * If the KMS key is a multi-Region primary key with replica keys, this field does not appear. The deletion date for the primary key isn't known until its last replica key is deleted.
         */
        public var deletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key whose deletion is scheduled.
         */
        public var keyId: kotlin.String? = null
        /**
         * The current status of the KMS key.
         *
         * For more information about how key state affects the use of a KMS key, see [Key states of KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html) in the *Key Management Service Developer Guide*.
         */
        public var keyState: aws.sdk.kotlin.services.kms.model.KeyState? = null
        /**
         * The waiting period before the KMS key is deleted.
         *
         * If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
         */
        public var pendingWindowInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionResponse) : this() {
            this.deletionDate = x.deletionDate
            this.keyId = x.keyId
            this.keyState = x.keyState
            this.pendingWindowInDays = x.pendingWindowInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionResponse = ScheduleKeyDeletionResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
