// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about completed key material rotations.
 */
public class RotationsListEntry private constructor(builder: Builder) {
    /**
     * Unique identifier of the key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Date and time that the key material rotation completed. Formatted as Unix time.
     */
    public val rotationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.rotationDate
    /**
     * Identifies whether the key material rotation was a scheduled [automatic rotation](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotating-keys-enable-disable) or an [on-demand rotation](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotating-keys-on-demand).
     */
    public val rotationType: aws.sdk.kotlin.services.kms.model.RotationType? = builder.rotationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.RotationsListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RotationsListEntry(")
        append("keyId=$keyId,")
        append("rotationDate=$rotationDate,")
        append("rotationType=$rotationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (rotationDate?.hashCode() ?: 0)
        result = 31 * result + (rotationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RotationsListEntry

        if (keyId != other.keyId) return false
        if (rotationDate != other.rotationDate) return false
        if (rotationType != other.rotationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.RotationsListEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique identifier of the key.
         */
        public var keyId: kotlin.String? = null
        /**
         * Date and time that the key material rotation completed. Formatted as Unix time.
         */
        public var rotationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Identifies whether the key material rotation was a scheduled [automatic rotation](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotating-keys-enable-disable) or an [on-demand rotation](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotating-keys-on-demand).
         */
        public var rotationType: aws.sdk.kotlin.services.kms.model.RotationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.RotationsListEntry) : this() {
            this.keyId = x.keyId
            this.rotationDate = x.rotationDate
            this.rotationType = x.rotationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.RotationsListEntry = RotationsListEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
