// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateCustomKeyStoreOperationDeserializer: HttpDeserializer.NonStreaming<UpdateCustomKeyStoreResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateCustomKeyStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateCustomKeyStoreError(context, call, payload)
        }
        val builder = UpdateCustomKeyStoreResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateCustomKeyStoreError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "XksProxyIncorrectAuthenticationCredentialException" -> XksProxyIncorrectAuthenticationCredentialExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyVpcEndpointServiceInvalidConfigurationException" -> XksProxyVpcEndpointServiceInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CustomKeyStoreNameInUseException" -> CustomKeyStoreNameInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmClusterNotFoundException" -> CloudHsmClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyVpcEndpointServiceInUseException" -> XksProxyVpcEndpointServiceInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyInvalidResponseException" -> XksProxyInvalidResponseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyInvalidConfigurationException" -> XksProxyInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyUriUnreachableException" -> XksProxyUriUnreachableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmClusterNotRelatedException" -> CloudHsmClusterNotRelatedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyUriInUseException" -> XksProxyUriInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyVpcEndpointServiceNotFoundException" -> XksProxyVpcEndpointServiceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "XksProxyUriEndpointInUseException" -> XksProxyUriEndpointInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CloudHsmClusterNotActiveException" -> CloudHsmClusterNotActiveExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CustomKeyStoreInvalidStateException" -> CustomKeyStoreInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CustomKeyStoreNotFoundException" -> CustomKeyStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
