// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.ImportKeyMaterialResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ImportKeyMaterialOperationDeserializer: HttpDeserializer.NonStreaming<ImportKeyMaterialResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ImportKeyMaterialResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwImportKeyMaterialError(context, call, payload)
        }
        val builder = ImportKeyMaterialResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwImportKeyMaterialError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExpiredImportTokenException" -> ExpiredImportTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImportTokenException" -> InvalidImportTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCiphertextException" -> InvalidCiphertextExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IncorrectKeyMaterialException" -> IncorrectKeyMaterialExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
