// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.GenerateMacRequest
import aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64String


internal class GenerateMacOperationSerializer: HttpSerializer.NonStreaming<GenerateMacRequest> {
    override fun serialize(context: ExecutionContext, input: GenerateMacRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeGenerateMacOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeGenerateMacOperationBody(context: ExecutionContext, input: GenerateMacRequest): ByteArray {
    val serializer = JsonSerializer()
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DryRun"))
    val GRANTTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GrantTokens"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val MACALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MacAlgorithm"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Message"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DRYRUN_DESCRIPTOR)
        field(GRANTTOKENS_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(MACALGORITHM_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        if (input.grantTokens != null) {
            listField(GRANTTOKENS_DESCRIPTOR) {
                for (el0 in input.grantTokens) {
                    serializeString(el0)
                }
            }
        }
        input.keyId?.let { field(KEYID_DESCRIPTOR, it) }
        input.macAlgorithm?.let { field(MACALGORITHM_DESCRIPTOR, it.value) }
        input.message?.let { field(MESSAGE_DESCRIPTOR, it.encodeBase64String()) }
    }
    return serializer.toByteArray()
}
