// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SignResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key that was used to sign the message.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The cryptographic signature that was generated for the message.
     * + When used with the supported RSA signing algorithms, the encoding of this value is defined by [PKCS #1 in RFC 8017](https://tools.ietf.org/html/rfc8017).
     * + When used with the `ECDSA_SHA_256`, `ECDSA_SHA_384`, or `ECDSA_SHA_512` signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and [RFC 3279 Section 2.2.3](https://tools.ietf.org/html/rfc3279#section-2.2.3). This is the most commonly used signature format and is appropriate for most uses.
     *
     * When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val signature: kotlin.ByteArray? = builder.signature
    /**
     * The signing algorithm that was used to sign the message.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.SignResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignResponse(")
        append("keyId=$keyId,")
        append("signature=$signature,")
        append("signingAlgorithm=$signingAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (signature?.contentHashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignResponse

        if (keyId != other.keyId) return false
        if (signature != null) {
            if (other.signature == null) return false
            if (!signature.contentEquals(other.signature)) return false
        } else if (other.signature != null) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.SignResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key that was used to sign the message.
         */
        public var keyId: kotlin.String? = null
        /**
         * The cryptographic signature that was generated for the message.
         * + When used with the supported RSA signing algorithms, the encoding of this value is defined by [PKCS #1 in RFC 8017](https://tools.ietf.org/html/rfc8017).
         * + When used with the `ECDSA_SHA_256`, `ECDSA_SHA_384`, or `ECDSA_SHA_512` signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and [RFC 3279 Section 2.2.3](https://tools.ietf.org/html/rfc3279#section-2.2.3). This is the most commonly used signature format and is appropriate for most uses.
         *
         * When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var signature: kotlin.ByteArray? = null
        /**
         * The signing algorithm that was used to sign the message.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.SignResponse) : this() {
            this.keyId = x.keyId
            this.signature = x.signature
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.SignResponse = SignResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
