// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the party that receives the response from the API operation.
 *
 * This data type is designed to support Amazon Web Services Nitro Enclaves, which lets you create an isolated compute environment in Amazon EC2. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
 */
public class RecipientInfo private constructor(builder: Builder) {
    /**
     * The attestation document for an Amazon Web Services Nitro Enclave. This document includes the enclave's public key.
     */
    public val attestationDocument: kotlin.ByteArray? = builder.attestationDocument
    /**
     * The encryption algorithm that KMS should use with the public key for an Amazon Web Services Nitro Enclave to encrypt plaintext values for the response. The only valid value is `RSAES_OAEP_SHA_256`.
     */
    public val keyEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.KeyEncryptionMechanism? = builder.keyEncryptionAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.RecipientInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecipientInfo(")
        append("attestationDocument=$attestationDocument,")
        append("keyEncryptionAlgorithm=$keyEncryptionAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attestationDocument?.contentHashCode() ?: 0
        result = 31 * result + (keyEncryptionAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecipientInfo

        if (attestationDocument != null) {
            if (other.attestationDocument == null) return false
            if (!attestationDocument.contentEquals(other.attestationDocument)) return false
        } else if (other.attestationDocument != null) return false
        if (keyEncryptionAlgorithm != other.keyEncryptionAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.RecipientInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The attestation document for an Amazon Web Services Nitro Enclave. This document includes the enclave's public key.
         */
        public var attestationDocument: kotlin.ByteArray? = null
        /**
         * The encryption algorithm that KMS should use with the public key for an Amazon Web Services Nitro Enclave to encrypt plaintext values for the response. The only valid value is `RSAES_OAEP_SHA_256`.
         */
        public var keyEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.KeyEncryptionMechanism? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.RecipientInfo) : this() {
            this.attestationDocument = x.attestationDocument
            this.keyEncryptionAlgorithm = x.keyEncryptionAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.RecipientInfo = RecipientInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
