// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.GetKeyRotationStatusResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetKeyRotationStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetKeyRotationStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetKeyRotationStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetKeyRotationStatusError(context, call, payload)
        }
        val builder = GetKeyRotationStatusResponse.Builder()

        if (payload != null) {
            deserializeGetKeyRotationStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetKeyRotationStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetKeyRotationStatusOperationBody(builder: GetKeyRotationStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val KEYROTATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("KeyRotationEnabled"))
    val NEXTROTATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("NextRotationDate"))
    val ONDEMANDROTATIONSTARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("OnDemandRotationStartDate"))
    val ROTATIONPERIODINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RotationPeriodInDays"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYID_DESCRIPTOR)
        field(KEYROTATIONENABLED_DESCRIPTOR)
        field(NEXTROTATIONDATE_DESCRIPTOR)
        field(ONDEMANDROTATIONSTARTDATE_DESCRIPTOR)
        field(ROTATIONPERIODINDAYS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                KEYROTATIONENABLED_DESCRIPTOR.index -> builder.keyRotationEnabled = deserializeBoolean()
                NEXTROTATIONDATE_DESCRIPTOR.index -> builder.nextRotationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ONDEMANDROTATIONSTARTDATE_DESCRIPTOR.index -> builder.onDemandRotationStartDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROTATIONPERIODINDAYS_DESCRIPTOR.index -> builder.rotationPeriodInDays = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
