// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.paginators

import aws.sdk.kotlin.services.kms.KmsClient
import aws.sdk.kotlin.services.kms.model.AliasListEntry
import aws.sdk.kotlin.services.kms.model.CustomKeyStoresListEntry
import aws.sdk.kotlin.services.kms.model.DescribeCustomKeyStoresRequest
import aws.sdk.kotlin.services.kms.model.DescribeCustomKeyStoresResponse
import aws.sdk.kotlin.services.kms.model.GrantListEntry
import aws.sdk.kotlin.services.kms.model.KeyListEntry
import aws.sdk.kotlin.services.kms.model.ListAliasesRequest
import aws.sdk.kotlin.services.kms.model.ListAliasesResponse
import aws.sdk.kotlin.services.kms.model.ListGrantsRequest
import aws.sdk.kotlin.services.kms.model.ListGrantsResponse
import aws.sdk.kotlin.services.kms.model.ListKeyPoliciesRequest
import aws.sdk.kotlin.services.kms.model.ListKeyPoliciesResponse
import aws.sdk.kotlin.services.kms.model.ListKeyRotationsRequest
import aws.sdk.kotlin.services.kms.model.ListKeyRotationsResponse
import aws.sdk.kotlin.services.kms.model.ListKeysRequest
import aws.sdk.kotlin.services.kms.model.ListKeysResponse
import aws.sdk.kotlin.services.kms.model.ListResourceTagsRequest
import aws.sdk.kotlin.services.kms.model.ListResourceTagsResponse
import aws.sdk.kotlin.services.kms.model.ListRetirableGrantsRequest
import aws.sdk.kotlin.services.kms.model.ListRetirableGrantsResponse
import aws.sdk.kotlin.services.kms.model.RotationsListEntry
import aws.sdk.kotlin.services.kms.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeCustomKeyStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCustomKeyStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCustomKeyStoresResponse]
 */
public fun KmsClient.describeCustomKeyStoresPaginated(initialRequest: DescribeCustomKeyStoresRequest = DescribeCustomKeyStoresRequest { }): Flow<DescribeCustomKeyStoresResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCustomKeyStoresPaginated.describeCustomKeyStores(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCustomKeyStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCustomKeyStoresResponse]
 */
public fun KmsClient.describeCustomKeyStoresPaginated(block: DescribeCustomKeyStoresRequest.Builder.() -> Unit): Flow<DescribeCustomKeyStoresResponse> =
    describeCustomKeyStoresPaginated(DescribeCustomKeyStoresRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCustomKeyStoresPaginated]
 * to access the nested member [CustomKeyStoresListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomKeyStoresListEntry]
 */
@JvmName("describeCustomKeyStoresResponseCustomKeyStoresListEntry")
public fun Flow<DescribeCustomKeyStoresResponse>.customKeyStores(): Flow<CustomKeyStoresListEntry> =
    transform() { response ->
        response.customKeyStores?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun KmsClient.listAliasesPaginated(initialRequest: ListAliasesRequest = ListAliasesRequest { }): Flow<ListAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listAliasesPaginated.listAliases(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun KmsClient.listAliasesPaginated(block: ListAliasesRequest.Builder.() -> Unit): Flow<ListAliasesResponse> =
    listAliasesPaginated(ListAliasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAliasesPaginated]
 * to access the nested member [AliasListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AliasListEntry]
 */
@JvmName("listAliasesResponseAliasListEntry")
public fun Flow<ListAliasesResponse>.aliases(): Flow<AliasListEntry> =
    transform() { response ->
        response.aliases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGrantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGrantsResponse]
 */
public fun KmsClient.listGrantsPaginated(initialRequest: ListGrantsRequest): Flow<ListGrantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listGrantsPaginated.listGrants(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGrantsResponse]
 */
public fun KmsClient.listGrantsPaginated(block: ListGrantsRequest.Builder.() -> Unit): Flow<ListGrantsResponse> =
    listGrantsPaginated(ListGrantsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGrantsPaginated]
 * to access the nested member [GrantListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GrantListEntry]
 */
@JvmName("listGrantsResponseGrantListEntry")
public fun Flow<ListGrantsResponse>.grants(): Flow<GrantListEntry> =
    transform() { response ->
        response.grants?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKeyPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeyPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyPoliciesResponse]
 */
public fun KmsClient.listKeyPoliciesPaginated(initialRequest: ListKeyPoliciesRequest): Flow<ListKeyPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listKeyPoliciesPaginated.listKeyPolicies(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeyPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyPoliciesResponse]
 */
public fun KmsClient.listKeyPoliciesPaginated(block: ListKeyPoliciesRequest.Builder.() -> Unit): Flow<ListKeyPoliciesResponse> =
    listKeyPoliciesPaginated(ListKeyPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeyPoliciesPaginated]
 * to access the nested member [PolicyNameType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyNameType]
 */
@JvmName("listKeyPoliciesResponsePolicyNameType")
public fun Flow<ListKeyPoliciesResponse>.policyNames(): Flow<String> =
    transform() { response ->
        response.policyNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKeyRotationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeyRotationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyRotationsResponse]
 */
public fun KmsClient.listKeyRotationsPaginated(initialRequest: ListKeyRotationsRequest): Flow<ListKeyRotationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listKeyRotationsPaginated.listKeyRotations(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeyRotationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyRotationsResponse]
 */
public fun KmsClient.listKeyRotationsPaginated(block: ListKeyRotationsRequest.Builder.() -> Unit): Flow<ListKeyRotationsResponse> =
    listKeyRotationsPaginated(ListKeyRotationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeyRotationsPaginated]
 * to access the nested member [RotationsListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RotationsListEntry]
 */
@JvmName("listKeyRotationsResponseRotationsListEntry")
public fun Flow<ListKeyRotationsResponse>.rotations(): Flow<RotationsListEntry> =
    transform() { response ->
        response.rotations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeysResponse]
 */
public fun KmsClient.listKeysPaginated(initialRequest: ListKeysRequest = ListKeysRequest { }): Flow<ListKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listKeysPaginated.listKeys(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeysResponse]
 */
public fun KmsClient.listKeysPaginated(block: ListKeysRequest.Builder.() -> Unit): Flow<ListKeysResponse> =
    listKeysPaginated(ListKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeysPaginated]
 * to access the nested member [KeyListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KeyListEntry]
 */
@JvmName("listKeysResponseKeyListEntry")
public fun Flow<ListKeysResponse>.keys(): Flow<KeyListEntry> =
    transform() { response ->
        response.keys?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceTagsResponse]
 */
public fun KmsClient.listResourceTagsPaginated(initialRequest: ListResourceTagsRequest): Flow<ListResourceTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listResourceTagsPaginated.listResourceTags(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceTagsResponse]
 */
public fun KmsClient.listResourceTagsPaginated(block: ListResourceTagsRequest.Builder.() -> Unit): Flow<ListResourceTagsResponse> =
    listResourceTagsPaginated(ListResourceTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceTagsPaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listResourceTagsResponseTag")
public fun Flow<ListResourceTagsResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRetirableGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRetirableGrantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetirableGrantsResponse]
 */
public fun KmsClient.listRetirableGrantsPaginated(initialRequest: ListRetirableGrantsRequest): Flow<ListRetirableGrantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listRetirableGrantsPaginated.listRetirableGrants(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRetirableGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetirableGrantsResponse]
 */
public fun KmsClient.listRetirableGrantsPaginated(block: ListRetirableGrantsRequest.Builder.() -> Unit): Flow<ListRetirableGrantsResponse> =
    listRetirableGrantsPaginated(ListRetirableGrantsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRetirableGrantsPaginated]
 * to access the nested member [GrantListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GrantListEntry]
 */
@JvmName("listRetirableGrantsResponseGrantListEntry")
public fun Flow<ListRetirableGrantsResponse>.grants(): Flow<GrantListEntry> =
    transform() { response ->
        response.grants?.forEach {
            emit(it)
        }
    }
